/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.Message;

public class BlobMessage
implements Message {
    static final long serialVersionUID = 20170529L;
    private String mimetype;
    private String encoding;
    private String filename;
    private String path;
    private String content;

    public BlobMessage() {
    }

    private BlobMessage(StringMessageBuilder builder) {
        this.mimetype = builder.mimetype;
        this.encoding = builder.encoding;
        this.filename = builder.filename;
        this.path = builder.path;
        this.content = builder.content;
        if ((this.path == null || this.path.isEmpty()) && this.content == null || this.content.isEmpty()) {
            throw new IllegalArgumentException("BlobMessage must be initialized with a file path or content");
        }
    }

    public String getId() {
        return this.filename;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContent() {
        return this.content;
    }

    public String getPath() {
        return this.path;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.mimetype);
        out.writeObject(this.encoding);
        out.writeObject(this.filename);
        out.writeObject(this.path);
        out.writeObject(this.content);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mimetype = (String)in.readObject();
        this.encoding = (String)in.readObject();
        this.filename = (String)in.readObject();
        this.path = (String)in.readObject();
        this.content = (String)in.readObject();
    }

    public static class FileMessageBuilder
    extends StringMessageBuilder {
        public FileMessageBuilder(String path) {
            super(null);
            this.setPath(path);
        }
    }

    public static class StringMessageBuilder {
        private String mimetype;
        private String encoding;
        private String filename;
        private String path;
        private String content;

        public StringMessageBuilder(String content) {
            this.content = content;
        }

        public StringMessageBuilder setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public StringMessageBuilder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public StringMessageBuilder setMimetype(String mimetype) {
            this.mimetype = mimetype;
            return this;
        }

        protected StringMessageBuilder setPath(String path) {
            this.path = path;
            this.content = null;
            return this;
        }

        public BlobMessage build() {
            return new BlobMessage(this);
        }
    }
}

