/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern.producer;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.message.DocumentMessage;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.AbstractProducer;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.RandomBlobInfoProvider;
import org.nuxeo.ecm.platform.importer.random.DictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.HunspellDictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.RandomTextGenerator;

public class RandomDocumentMessageProducer
extends AbstractProducer<DocumentMessage> {
    private static final Log log = LogFactory.getLog(RandomDocumentMessageProducer.class);
    private final long nbDocuments;
    private final RandomBlobInfoProvider blobInfoProvider;
    private boolean countFolderAsDocument = true;
    private int maxFoldersPerFolder = 50;
    private int maxDocumentsPerFolder = 500;
    private int blobSizeKB = 0;
    private boolean blobOnlyText = false;
    private int documentCount = 0;
    private int folderCount = 0;
    private final Random rand;
    private static RandomTextGenerator gen;
    protected static final String[] DC_NATURE;
    protected static final String[] DC_SUBJECTS;
    protected static final String[] DC_RIGHTS;
    protected static final String[] DC_LANGUAGE;
    protected static final String[] DC_SOURCE;
    protected static final String[] DC_COVERAGE;
    private int foldersInCurrentFolderLimit;
    private int documentInCurrentFolderLimit;
    private DocType currentType = DocType.Root;
    private int parentIndex = 0;
    private List<String> parents = new ArrayList<String>();
    private List<String> children = new ArrayList<String>();
    private int documentInCurrentFolderCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomDocumentMessageProducer(int producerId, long nbDocuments, String lang, Path blobInfoDirectory) {
        super(producerId);
        this.nbDocuments = nbDocuments;
        this.rand = ThreadLocalRandom.current();
        Class<RandomDocumentMessageProducer> clazz = RandomDocumentMessageProducer.class;
        synchronized (RandomDocumentMessageProducer.class) {
            if (gen == null) {
                gen = new RandomTextGenerator((DictionaryHolder)new HunspellDictionaryHolder(lang));
                gen.prefilCache();
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            this.blobInfoProvider = blobInfoDirectory != null ? new RandomBlobInfoProvider(blobInfoDirectory, producerId) : null;
            log.info((Object)("RandomDocumentMessageProducer created, nbDocuments: " + nbDocuments));
            return;
        }
    }

    public RandomDocumentMessageProducer setMaxFoldersPerFolder(int max) {
        this.maxFoldersPerFolder = max;
        return this;
    }

    public RandomDocumentMessageProducer setMaxDocumentsPerFolder(int max) {
        this.maxDocumentsPerFolder = max;
        return this;
    }

    public RandomDocumentMessageProducer countFolderAsDocument(boolean value) {
        this.countFolderAsDocument = value;
        return this;
    }

    public RandomDocumentMessageProducer withBlob(int sizeKB, boolean onlyText) {
        this.blobSizeKB = sizeKB;
        this.blobOnlyText = onlyText;
        return this;
    }

    public int getPartition(DocumentMessage message, int partitions) {
        return this.getProducerId() % partitions;
    }

    public boolean hasNext() {
        if (this.countFolderAsDocument) {
            return (long)(this.documentCount + this.folderCount) < this.nbDocuments;
        }
        return (long)this.documentCount <= this.nbDocuments;
    }

    public DocumentMessage next() {
        DocumentMessage ret;
        switch (this.currentType) {
            case Root: {
                ret = this.createRoot();
                this.parents.add(ret.getId());
                this.currentType = DocType.Folder;
                this.foldersInCurrentFolderLimit = this.rand.nextInt(this.maxFoldersPerFolder) + 1;
                break;
            }
            case Folder: {
                ret = this.createFolder(this.parents.get(this.parentIndex));
                this.children.add(ret.getId());
                if (this.children.size() < this.foldersInCurrentFolderLimit) break;
                this.currentType = DocType.Document;
                this.documentInCurrentFolderCount = 0;
                this.documentInCurrentFolderLimit = this.rand.nextInt(this.maxDocumentsPerFolder);
                break;
            }
            default: {
                ret = this.createDocument(this.parents.get(this.parentIndex), this.children);
                ++this.documentInCurrentFolderCount;
                if (this.documentInCurrentFolderCount <= this.documentInCurrentFolderLimit) break;
                ++this.parentIndex;
                if (this.parentIndex >= this.parents.size()) {
                    this.parents.clear();
                    this.parents = this.children;
                    this.children = new ArrayList<String>();
                    this.parentIndex = 0;
                }
                this.currentType = DocType.Folder;
                this.foldersInCurrentFolderLimit = this.rand.nextInt(this.maxFoldersPerFolder) + 1;
            }
        }
        return ret;
    }

    private DocumentMessage createRoot() {
        ++this.folderCount;
        return this.getRandomNodeWithPrefix(String.format("%02d-", this.getProducerId()), "Folder", "");
    }

    private DocumentMessage createFolder(String parentPath) {
        DocumentMessage node = this.getRandomNode("Folder", parentPath, false);
        ++this.folderCount;
        return node;
    }

    private DocumentMessage createDocument(String parentPath, List<String> exclude) {
        DocumentMessage node = this.getRandomNode("File", parentPath, true);
        String ret = node.getId();
        while (exclude.contains(ret)) {
            log.debug((Object)"duplicate found");
            node = this.getRandomNode("File", parentPath, true);
            ret = node.getId();
        }
        ++this.documentCount;
        return node;
    }

    private DocumentMessage getRandomNode(String type, String parentPath, boolean withBlob) {
        String title = this.getTitle();
        String name = this.getName(title);
        HashMap<String, Serializable> props = this.getRandomProperties(title);
        DocumentMessage.Builder builder = DocumentMessage.builder(type, parentPath, name).setProperties(props);
        if (withBlob) {
            if (this.blobInfoProvider != null) {
                builder.setBlobInfo(this.blobInfoProvider.getBlobInfo(builder));
            } else {
                builder.setBlob(this.getRandomBlob());
            }
        }
        return builder.build();
    }

    private DocumentMessage getRandomNodeWithPrefix(String prefix, String type, String parentPath) {
        String title = this.getTitle();
        String name = prefix + this.getName(title);
        HashMap<String, Serializable> props = this.getRandomProperties(title);
        DocumentMessage.Builder builder = DocumentMessage.builder(type, parentPath, name).setProperties(props);
        if (this.blobInfoProvider != null) {
            builder.setBlobInfo(this.blobInfoProvider.getBlobInfo(builder));
        } else {
            builder.setBlob(this.getRandomBlob());
        }
        return builder.build();
    }

    private Blob getRandomBlob() {
        if (this.blobSizeKB == 0) {
            return null;
        }
        String content = gen.getRandomText(this.blobSizeKB);
        return Blobs.createBlob((String)content, (String)this.getBlobMimeType(), null, (String)(this.getName(this.getTitle()) + ".txt"));
    }

    private String getBlobMimeType() {
        if (this.blobOnlyText) {
            return "text/plain";
        }
        return "text/partial";
    }

    private String getName(String title) {
        return title.replaceAll("\\W+", "-").toLowerCase();
    }

    private String getTitle() {
        return this.capitalize(gen.getRandomTitle(this.rand.nextInt(3) + 1).trim());
    }

    private String capitalize(String line) {
        return Character.toUpperCase(line.charAt(0)) + line.substring(1);
    }

    protected HashMap<String, Serializable> getRandomProperties(String title) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("dc:title", (Serializable)((Object)title));
        if (this.rand.nextInt(10) == 1) {
            String description = gen.getRandomTitle(this.rand.nextInt(5) + 1);
            ret.put("dc:description", (Serializable)((Object)this.capitalize(description)));
        }
        ret.put("dc:nature", (Serializable)((Object)this.getGaussian(DC_NATURE)));
        ret.put("dc:subjects", (Serializable)((Object)Collections.singletonList(this.getGaussian(DC_SUBJECTS))));
        ret.put("dc:rights", (Serializable)((Object)this.getGaussian(DC_RIGHTS)));
        ret.put("dc:language", (Serializable)((Object)this.getGaussian(DC_LANGUAGE)));
        ret.put("dc:coverage", (Serializable)((Object)this.getGaussian(DC_COVERAGE)));
        ret.put("dc:source", (Serializable)((Object)this.getGaussian(DC_SOURCE)));
        return ret;
    }

    protected String getGaussian(String[] words) {
        double g = Math.abs(this.rand.nextGaussian() / 4.0);
        g = Math.min(g, 1.0);
        int i = (int)Math.floor(g * (double)(words.length - 1));
        return words[i];
    }

    static {
        DC_NATURE = new String[]{"article", "acknowledgement", "assessment", "application", "order", "contract", "quotation", "fax", "worksheet", "letter", "memo", "note", "notification", "procedure", "report", "internshipReport", "pressReview"};
        DC_SUBJECTS = new String[]{"art/architecture", "art/comics", "art/cinema", "art/culture", "art/danse", "art/music", "sciences/astronomy", "sciences/biology", "sciences/chemistry", "sciences/math", "sciences/physic", "society/ecology", "daily life/gastronomy", "daily life/gardening", "daily life/sport", "technology/it"};
        DC_RIGHTS = new String[]{"OpenContentL", "CC-BY-NC", "CC-BY-ND", "FreeArt", "ODbi", "GNUGPL", "FreeBSD", "CC0"};
        DC_LANGUAGE = new String[]{"IT", "DE", "FR", "US", "EN"};
        DC_SOURCE = new String[]{"internal", "external", "unknown"};
        DC_COVERAGE = new String[]{"europe/France", "europe/Germany", "europe/Italy", "europe/Spain", "oceania/Tonga", "africa/Mali", "asia/Japan", "north-america/United_States_of_America"};
    }

    private static enum DocType {
        Root,
        Folder,
        Document;

    }
}

