/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.workmanager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.importer.mqueues.computation.AbstractComputation;
import org.nuxeo.ecm.platform.importer.mqueues.computation.ComputationContext;
import org.nuxeo.ecm.platform.importer.mqueues.computation.Record;

public class ComputationWork
extends AbstractComputation {
    public ComputationWork(String name) {
        super(name, 1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        Work work = ComputationWork.deserialize(record.data);
        try {
            work.run();
        }
        finally {
            work.cleanUp(true, null);
        }
        context.askForCheckpoint();
    }

    public void init(ComputationContext context) {
        super.init(context);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
    }

    public static Work deserialize(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            Work work = (Work)in.readObject();
            return work;
        }
        catch (IOException | ClassNotFoundException e) {
            System.out.println("Error " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Work work) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(work);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            System.out.println("Error " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

