/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.workmanager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.importer.mqueues.computation.Record;
import org.nuxeo.ecm.platform.importer.mqueues.kafka.KafkaConfigService;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQManager;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.kafka.KafkaMQManager;
import org.nuxeo.ecm.platform.importer.mqueues.workmanager.WorkManagerComputation;
import org.nuxeo.runtime.api.Framework;

public class WorkManagerComputationKafka
extends WorkManagerComputation {
    protected static final Log log = LogFactory.getLog(WorkManagerComputationKafka.class);
    public static final String NUXEO_WORKMANAGER_KAFKA_CONFIG_PROP = "nuxeo.mqueue.work.kafka.config";
    public static final String NUXEO_WORKMANAGER_KAFKA_OVERPROVISIONING_PROP = "nuxeo.mqueue.work.kafka.overprovisioning";
    public static final String DEFAULT_CONFIG = "default";
    public static final String DEFAULT_OVERPROVISIONING = "3";

    @Override
    protected MQManager<Record> initStream() {
        KafkaConfigService service = (KafkaConfigService)Framework.getService(KafkaConfigService.class);
        String kafkaConfig = Framework.getProperty((String)NUXEO_WORKMANAGER_KAFKA_CONFIG_PROP, (String)DEFAULT_CONFIG);
        log.info((Object)("Init WorkManagerComputation with Kafka, using configuration: " + kafkaConfig));
        return new KafkaMQManager(service.getZkServers(kafkaConfig), service.getTopicPrefix(kafkaConfig), service.getProducerProperties(kafkaConfig), service.getConsumerProperties(kafkaConfig));
    }

    @Override
    protected int getOverProvisioningFactor() {
        return Integer.valueOf(Framework.getProperty((String)NUXEO_WORKMANAGER_KAFKA_OVERPROVISIONING_PROP, (String)DEFAULT_OVERPROVISIONING));
    }
}

