/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.computation;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ComputationMetadata {
    protected final String name;
    protected final Set<String> istreams;
    protected final Set<String> ostreams;

    public String name() {
        return this.name;
    }

    public Set<String> inputStreams() {
        return this.istreams;
    }

    public Set<String> outputStreams() {
        return this.ostreams;
    }

    public ComputationMetadata(String name, Set<String> inputStreams, Set<String> outputStreams) {
        this.name = Objects.requireNonNull(name);
        this.istreams = inputStreams == null ? Collections.emptySet() : inputStreams;
        this.ostreams = outputStreams == null ? Collections.emptySet() : outputStreams;
        if (this.istreams.isEmpty() && this.ostreams.isEmpty()) {
            throw new RuntimeException("Both input and output streams are empty");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputationMetadata metadata = (ComputationMetadata)o;
        if (!this.name.equals(metadata.name)) {
            return false;
        }
        if (!this.istreams.equals(metadata.istreams)) {
            return false;
        }
        return this.ostreams.equals(metadata.ostreams);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.istreams.hashCode();
        result = 31 * result + this.ostreams.hashCode();
        return result;
    }

    public String toString() {
        return "ComputationMetadata{name='" + this.name + '\'' + ", istreams=" + this.istreams.stream().collect(Collectors.joining(",")) + ", ostreams=" + this.ostreams.stream().collect(Collectors.joining(",")) + '}';
    }
}

