/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.computation.internals;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.importer.mqueues.computation.Watermark;

public class WatermarkMonotonicInterval {
    private static final Log log = LogFactory.getLog(WatermarkMonotonicInterval.class);
    private volatile Watermark low = Watermark.LOWEST;
    private Watermark lowest = Watermark.LOWEST;
    private Watermark high = Watermark.LOWEST;

    public long mark(long watermarkValue) {
        return this.mark(Watermark.ofValue(watermarkValue));
    }

    public long mark(Watermark watermark) {
        if (this.low == Watermark.LOWEST) {
            this.low = this.high = watermark;
        } else if (watermark.compareTo(this.low) < 0) {
            if (watermark.compareTo(this.lowest) < 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("receive too low watermark, rejected " + watermark + " lowest: " + this.lowest));
                }
                this.low = this.lowest;
            } else {
                this.low = watermark;
            }
        }
        if (watermark.compareTo(this.high) > 0) {
            this.high = watermark;
        }
        return this.low.getValue();
    }

    public long checkpoint() {
        this.lowest = this.low = Watermark.completedOf(this.high);
        return this.low.getValue();
    }

    public boolean isDone(long timestamp) {
        return this.low.isDone(timestamp);
    }

    public Watermark getLow() {
        return this.low;
    }

    public Watermark getHigh() {
        return this.high;
    }

    public String toString() {
        return "WatermarkInterval{low=" + this.low + ", high=" + this.high + '}';
    }
}

