/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern.producer;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQManager;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.Message;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.internals.AbstractCallablePool;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.ProducerFactory;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.ProducerStatus;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.internals.ProducerRunner;

public class ProducerPool<M extends Message>
extends AbstractCallablePool<ProducerStatus> {
    private static final Log log = LogFactory.getLog(ProducerPool.class);
    private final MQManager<M> manager;
    private final ProducerFactory<M> factory;
    private final String mqName;

    public ProducerPool(String mqName, MQManager<M> manager, ProducerFactory<M> factory, short nbThreads) {
        super(nbThreads);
        this.mqName = mqName;
        this.manager = manager;
        this.factory = factory;
    }

    @Override
    protected ProducerStatus getErrorStatus() {
        return new ProducerStatus(0, 0L, 0L, 0L, true);
    }

    @Override
    protected Callable<ProducerStatus> getCallable(int i) {
        return new ProducerRunner<M>(this.factory, this.manager.getAppender(this.mqName), i);
    }

    @Override
    protected String getThreadPrefix() {
        return "Nuxeo-Producer";
    }

    @Override
    protected void afterCall(List<ProducerStatus> ret) {
        ret.forEach(arg_0 -> ((Log)log).info(arg_0));
        log.warn((Object)ProducerStatus.toString(ret));
    }
}

