/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;

public class NativeBytes<Underlying>
extends VanillaBytes<Underlying> {
    NativeBytes(@NotNull BytesStore store) throws IllegalStateException {
        super(store, 0L, Long.MAX_VALUE);
    }

    @NotNull
    public static NativeBytes<Void> nativeBytes() {
        return new NativeBytes<Void>(NoBytesStore.noBytesStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NativeBytes<Void> nativeBytes(long initialCapacity) throws IllegalArgumentException {
        NativeBytesStore<Void> store = NativeBytesStore.nativeStoreWithFixedCapacity(initialCapacity);
        try {
            NativeBytes<Void> nativeBytes = new NativeBytes<Void>(store);
            return nativeBytes;
        }
        finally {
            store.release();
        }
    }

    public static BytesStore<Bytes<Void>, Void> copyOf(@NotNull Bytes bytes) {
        long remaining = bytes.readRemaining();
        NativeBytes<Void> bytes2 = Bytes.allocateElasticDirect(remaining);
        bytes2.write(bytes, 0L, remaining);
        return bytes2;
    }

    private static long alignToPageSize(long size) {
        long mask = OS.pageSize() - 1;
        return size + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long capacity() {
        return Long.MAX_VALUE;
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException, IllegalArgumentException {
        if (offset < this.bytesStore.start()) {
            throw new BufferOverflowException();
        }
        long writeEnd = offset + adding;
        if (writeEnd > this.bytesStore.safeLimit()) {
            this.checkResize(writeEnd);
        }
    }

    @Override
    public void ensureCapacity(long size) throws IllegalArgumentException {
        try {
            assert (size >= 0L);
            this.writeCheckOffset(size, 0L);
        }
        catch (BufferOverflowException e) {
            throw new IllegalArgumentException("Bytes cannot be resized to " + size + " limit: " + this.capacity());
        }
    }

    private void checkResize(long endOfBuffer) throws BufferOverflowException, IllegalArgumentException {
        if (!this.isElastic()) {
            throw new BufferOverflowException();
        }
        this.resize(endOfBuffer);
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    private void resize(long endOfBuffer) throws IllegalArgumentException, BufferOverflowException {
        BytesStore store;
        boolean isByteBufferBacked;
        if (endOfBuffer < 0L) {
            throw new IllegalArgumentException(endOfBuffer + " < 0");
        }
        if (endOfBuffer > this.capacity()) {
            throw new BufferOverflowException();
        }
        long realCapacity = this.realCapacity();
        if (endOfBuffer <= realCapacity) {
            return;
        }
        long size = Math.max(endOfBuffer, realCapacity * 3L / 2L);
        size = Math.min(size, this.capacity());
        if (this.isDirectMemory() || size > (long)MAX_BYTE_BUFFER_CAPACITY) {
            size = NativeBytes.alignToPageSize(size);
            size = Math.min(size, this.capacity());
        }
        if ((isByteBufferBacked = this.bytesStore.underlyingObject() instanceof ByteBuffer) && size > (long)MAX_BYTE_BUFFER_CAPACITY) {
            Jvm.warn().on(this.getClass(), "Going to try to replace ByteBuffer-backed BytesStore with raw NativeBytesStore to grow to " + size / 1024L + " KB. If later it is assumed that " + "this bytes' underlyingObject() is ByteBuffer, NullPointerException is likely to be thrown");
        }
        if (endOfBuffer > 0x100000L) {
            Jvm.warn().on(this.getClass(), "Resizing buffer was " + realCapacity / 1024L + " KB, " + "needs " + endOfBuffer / 1024L + " KB, " + "new-size " + size / 1024L + " KB");
        }
        int position = 0;
        if (isByteBufferBacked && size <= (long)MAX_BYTE_BUFFER_CAPACITY) {
            position = ((ByteBuffer)this.bytesStore.underlyingObject()).position();
            store = this.allocateNewByteBufferBackedStore(Maths.toInt32((long)size));
        } else {
            store = NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity(size);
        }
        BytesStore tempStore = this.bytesStore;
        try {
            this.bytesStore.copyTo(store);
        }
        catch (IllegalStateException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
        this.bytesStore = store;
        tempStore.release();
        if (this.bytesStore.underlyingObject() instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)this.bytesStore.underlyingObject();
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
            byteBuffer.position(position);
        }
    }

    private BytesStore allocateNewByteBufferBackedStore(int size) {
        if (this.isDirectMemory()) {
            return NativeBytesStore.elasticByteBuffer(size, this.capacity());
        }
        return HeapBytesStore.wrap(ByteBuffer.allocate(size));
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        if ((long)length > this.writeRemaining()) {
            throw new BufferOverflowException();
        }
        long position = this.writePosition();
        this.ensureCapacity(position + (long)length);
        super.write(bytes, offset, length);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(BytesStore bytes, long offset, long length) throws BufferOverflowException, IllegalArgumentException, BufferUnderflowException {
        long position = this.writePosition();
        this.ensureCapacity(position + length);
        if (length >= 32L && this.isDirectMemory() && bytes.isDirectMemory()) {
            long address = bytes.address(offset);
            long address2 = this.address(this.writePosition());
            assert (address != 0L);
            assert (address2 != 0L);
            long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
            if (len > 0L) {
                this.writeCheckOffset(this.writePosition(), len);
                OS.memory().copyMemory(address, address2, len);
                this.writeSkip(len);
            }
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }
}

