/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.queue.impl.AbstractChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class SingleChronicleQueueBuilder
extends AbstractChronicleQueueBuilder<SingleChronicleQueueBuilder, SingleChronicleQueue> {
    @Deprecated
    public SingleChronicleQueueBuilder(@NotNull String path) {
        this(new File(path));
    }

    @Deprecated
    public SingleChronicleQueueBuilder(@NotNull File path) {
        super(path);
        this.storeFactory(SingleChronicleQueueBuilder::createStore);
    }

    public static void init() {
    }

    @NotNull
    public static SingleChronicleQueueBuilder binary(@NotNull Path path) {
        return SingleChronicleQueueBuilder.binary(path.toFile());
    }

    @NotNull
    public static SingleChronicleQueueBuilder binary(@NotNull String basePath) {
        return SingleChronicleQueueBuilder.binary(new File(basePath));
    }

    @NotNull
    public static SingleChronicleQueueBuilder defaultZeroBinary(@NotNull String basePath) {
        return SingleChronicleQueueBuilder.defaultZeroBinary(new File(basePath));
    }

    @NotNull
    public static SingleChronicleQueueBuilder binary(@NotNull File basePathFile) {
        return (SingleChronicleQueueBuilder)new SingleChronicleQueueBuilder(basePathFile).wireType(WireType.BINARY_LIGHT);
    }

    @NotNull
    public static SingleChronicleQueueBuilder defaultZeroBinary(@NotNull File basePathFile) {
        return (SingleChronicleQueueBuilder)new SingleChronicleQueueBuilder(basePathFile).wireType(WireType.DEFAULT_ZERO_BINARY);
    }

    @Deprecated
    @NotNull
    public static SingleChronicleQueueBuilder text(@NotNull File name) {
        return (SingleChronicleQueueBuilder)new SingleChronicleQueueBuilder(name).wireType(WireType.TEXT);
    }

    @NotNull
    static SingleChronicleQueueStore createStore(RollingChronicleQueue queue, Wire wire) {
        SingleChronicleQueueStore wireStore = new SingleChronicleQueueStore(queue.rollCycle(), queue.wireType(), (MappedBytes)wire.bytes(), queue.epoch(), queue.indexCount(), queue.indexSpacing(), queue.recoverySupplier().apply(queue.wireType()), queue.deltaCheckpointInterval());
        wire.writeEventName((WireKey)MetaDataKeys.header).typedMarshallable((WriteMarshallable)wireStore);
        return wireStore;
    }

    @Override
    @NotNull
    public SingleChronicleQueue build() {
        if (this.buffered()) {
            this.getLogger().warn("Buffering is only supported in Chronicle Queue Enterprise");
        }
        return new SingleChronicleQueue(this);
    }

    @NotNull
    public SingleChronicleQueueBuilder clone() {
        try {
            return (SingleChronicleQueueBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(WireType.class);
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQRoll.class, "SCQSRoll");
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQIndexing.class, "SCQSIndexing");
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleChronicleQueueStore.class, "SCQStore");
        ClassAliasPool.CLASS_ALIASES.addAlias(TimedStoreRecovery.class);
    }
}

