/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.util.Properties;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.admin.DeleteRecordsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeleteRecordsCommand$ {
    public static final DeleteRecordsCommand$ MODULE$;

    static {
        new DeleteRecordsCommand$();
    }

    public void main(String[] args) {
        this.execute(args, System.out);
    }

    public Seq<Tuple2<TopicPartition, Object>> parseOffsetJsonStringWithoutDedup(String jsonData) {
        Option<Object> option;
        block7: {
            Seq seq;
            block6: {
                block2: {
                    Option option2;
                    block5: {
                        Seq seq2;
                        block4: {
                            block3: {
                                option = Json$.MODULE$.parseFull(jsonData);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Object m = some.x();
                                option2 = ((Map)m).get((Object)"partitions");
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object partitionsSeq = some2.x();
                                seq2 = (Seq)((Seq)partitionsSeq).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<TopicPartition, Object> apply(Map<String, Object> p) {
                                        String topic = (String)p.get((Object)"topic").get();
                                        int partition = BoxesRunTime.unboxToInt((Object)p.get((Object)"partition").get());
                                        long offset2 = BoxesRunTime.unboxToInt((Object)p.get((Object)"offset").get());
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToLong((long)offset2));
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                break block4;
                            }
                            if (!None$.MODULE$.equals(option2)) break block5;
                            seq2 = (Seq)Seq$.MODULE$.empty();
                        }
                        seq = seq2;
                        break block6;
                    }
                    throw new MatchError((Object)option2);
                }
                if (!None$.MODULE$.equals(option)) break block7;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public void execute(String[] args, PrintStream out) {
        DeleteRecordsCommand.DeleteRecordsCommandOptions opts = new DeleteRecordsCommand.DeleteRecordsCommandOptions(args);
        AdminClient adminClient = this.createAdminClient(opts);
        String offsetJsonFile = (String)opts.options().valueOf(opts.offsetJsonFileOpt());
        String offsetJsonString = Utils.readFileAsString((String)offsetJsonFile);
        Seq<Tuple2<TopicPartition, Object>> offsetSeq = this.parseOffsetJsonStringWithoutDedup(offsetJsonString);
        Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates((Traversable)offsetSeq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, Object> x0$1) {
                Tuple2<TopicPartition, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp;
                    TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
                    return topicPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicatePartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Offset json file contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
        }
        out.println("Executing records delete operation");
        Map<TopicPartition, AdminClient.DeleteRecordsResult> deleteRecordsResult = adminClient.deleteRecordsBefore((Map<TopicPartition, Object>)offsetSeq.toMap(Predef$.MODULE$.$conforms())).get();
        out.println("Records delete operation completed:");
        deleteRecordsResult.foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final PrintStream out$1;

            public final void apply(Tuple2<TopicPartition, AdminClient.DeleteRecordsResult> x0$2) {
                Tuple2<TopicPartition, AdminClient.DeleteRecordsResult> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    AdminClient.DeleteRecordsResult partitionResult = (AdminClient.DeleteRecordsResult)tuple2._2();
                    if (partitionResult.error() == null) {
                        this.out$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition: ", "\\tlow_watermark: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToLong((long)partitionResult.lowWatermark())})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.out$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition: ", "\\terror: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, partitionResult.error().toString()})));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.out$1 = out$1;
            }
        });
        adminClient.close();
    }

    private AdminClient createAdminClient(DeleteRecordsCommand.DeleteRecordsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return AdminClient$.MODULE$.create(props);
    }

    private DeleteRecordsCommand$() {
        MODULE$ = this;
    }
}

