/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.computation;

import java.util.HashMap;
import java.util.Map;

public class Settings {
    private final int defaultConcurrency;
    private final int defaultPartitions;
    private final Map<String, Integer> concurrences = new HashMap<String, Integer>();
    private final Map<String, Integer> partitions = new HashMap<String, Integer>();

    public Settings(int defaultConcurrency, int defaultPartitions) {
        this.defaultConcurrency = defaultConcurrency;
        this.defaultPartitions = defaultPartitions;
    }

    public Settings setConcurrency(String computationName, int concurrency) {
        this.concurrences.put(computationName, concurrency);
        return this;
    }

    public int getConcurrency(String computationName) {
        return this.concurrences.getOrDefault(computationName, this.defaultConcurrency);
    }

    public Settings setPartitions(String streamName, int partitions) {
        this.partitions.put(streamName, partitions);
        return this;
    }

    public int getPartitions(String streamName) {
        return this.partitions.getOrDefault(streamName, this.defaultPartitions);
    }
}

