/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer;

import java.time.Duration;

public class BatchPolicy {
    public static final BatchPolicy NO_BATCH = BatchPolicy.builder().capacity(1).build();
    public static final BatchPolicy DEFAULT = BatchPolicy.builder().build();
    private final int capacity;
    private final Duration threshold;

    public BatchPolicy(Builder builder) {
        this.capacity = builder.capacity;
        this.threshold = builder.threshold;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Duration getTimeThreshold() {
        return this.threshold;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "BatchPolicy{capacity=" + this.capacity + ", threshold=" + this.threshold + '}';
    }

    public static class Builder {
        private int capacity = 10;
        private Duration threshold = Duration.ofSeconds(10L);

        protected Builder() {
        }

        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder timeThreshold(Duration threshold) {
            this.threshold = threshold;
            return this;
        }

        public BatchPolicy build() {
            return new BatchPolicy(this);
        }
    }
}

