/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer;

import java.time.Duration;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.BatchPolicy;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.ConsumerPolicy;

public class ConsumerPolicyBuilder {
    protected BatchPolicy batchPolicy = BatchPolicy.DEFAULT;
    protected RetryPolicy retryPolicy = ConsumerPolicy.NO_RETRY;
    protected boolean skipFailure = false;
    protected Duration waitMessageTimeout = Duration.ofSeconds(2L);
    protected ConsumerPolicy.StartOffset startOffset = ConsumerPolicy.StartOffset.LAST_COMMITTED;
    protected boolean salted = false;
    protected String name;
    protected short maxThreads = 0;

    protected ConsumerPolicyBuilder() {
    }

    public ConsumerPolicyBuilder batchPolicy(BatchPolicy policy) {
        this.batchPolicy = policy;
        return this;
    }

    public ConsumerPolicyBuilder retryPolicy(RetryPolicy policy) {
        this.retryPolicy = policy;
        return this;
    }

    public ConsumerPolicyBuilder continueOnFailure(boolean value) {
        this.skipFailure = value;
        return this;
    }

    public ConsumerPolicyBuilder maxThreads(short maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public ConsumerPolicyBuilder waitMessageTimeout(Duration duration) {
        this.waitMessageTimeout = duration;
        return this;
    }

    public ConsumerPolicyBuilder waitMessageForEver() {
        this.waitMessageTimeout = Duration.ofSeconds(Integer.MAX_VALUE);
        return this;
    }

    public ConsumerPolicyBuilder startOffset(ConsumerPolicy.StartOffset startOffset) {
        this.startOffset = startOffset;
        return this;
    }

    public ConsumerPolicyBuilder salted() {
        this.salted = true;
        return this;
    }

    public ConsumerPolicyBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ConsumerPolicy build() {
        return new ConsumerPolicy(this);
    }
}

