/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.random;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.importer.random.DictionaryHolder;

public class HunspellDictionaryHolder
implements DictionaryHolder {
    protected static final String DEFAULT_DIC = "fr_FR.dic";
    protected static final int INITIAL_SIZE = 100000;
    protected List<String> words = new ArrayList<String>(100000);
    protected Random generator = new Random(System.currentTimeMillis());
    protected int wordCount;
    protected String dicName = "fr_FR.dic";
    public static final Log log = LogFactory.getLog(HunspellDictionaryHolder.class);

    public HunspellDictionaryHolder(String lang) {
        if (lang != null) {
            this.dicName = lang.replaceAll("\\W+", "") + ".dic";
        }
    }

    @Override
    public void init() throws IOException {
        this.loadDic();
        this.wordCount = this.words.size();
    }

    @Deprecated
    protected void loadDic(String dicName) throws IOException {
        this.dicName = dicName;
        this.loadDic();
    }

    protected void loadDic() throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(this.dicName);
        if (url == null) {
            log.error((Object)("not found: " + this.dicName));
            return;
        }
        try (InputStream in = url.openStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf("/");
                if (idx > 0) {
                    String word = line.substring(0, idx);
                    this.words.add(word + " ");
                    continue;
                }
                this.words.add(line + " ");
            }
        }
    }

    @Override
    public int getWordCount() {
        return this.wordCount;
    }

    @Override
    public String getRandomWord() {
        int idx = this.generator.nextInt(this.wordCount);
        return this.words.get(idx);
    }
}

