/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.factories;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.importer.factories.AbstractDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class DefaultDocumentModelFactory
extends AbstractDocumentModelFactory {
    public static final String DOCTYPE_KEY_NAME = "ecm:primaryType";
    public static final String FACETS_KEY_NAME = "ecm:mixinTypes";
    protected String folderishType;
    protected String leafType;

    public DefaultDocumentModelFactory() {
        this("Folder", "File");
    }

    public DefaultDocumentModelFactory(String folderishType, String leafType) {
        this.folderishType = folderishType;
        this.leafType = leafType;
    }

    @Override
    public DocumentModel createFolderishNode(CoreSession session, DocumentModel parent, SourceNode node) throws IOException {
        String name = this.getValidNameFromFileName(node.getName());
        BlobHolder bh = node.getBlobHolder();
        String folderishTypeToUse = this.getDocTypeToUse(bh);
        if (folderishTypeToUse == null) {
            folderishTypeToUse = this.folderishType;
        }
        List<String> facets = this.getFacetsToUse(bh);
        DocumentModel doc = session.createDocumentModel(parent.getPathAsString(), name, folderishTypeToUse);
        for (String facet : facets) {
            doc.addFacet(facet);
        }
        doc.setProperty("dublincore", "title", (Object)node.getName());
        doc = session.createDocument(doc);
        if (bh != null) {
            doc = this.setDocumentProperties(session, bh.getProperties(), doc);
        }
        return doc;
    }

    @Override
    public DocumentModel createLeafNode(CoreSession session, DocumentModel parent, SourceNode node) throws IOException {
        return this.defaultCreateLeafNode(session, parent, node);
    }

    protected DocumentModel defaultCreateLeafNode(CoreSession session, DocumentModel parent, SourceNode node) throws IOException {
        Blob blob = null;
        Map props = null;
        String leafTypeToUse = this.leafType;
        BlobHolder bh = node.getBlobHolder();
        if (bh != null) {
            blob = bh.getBlob();
            props = bh.getProperties();
            String bhType = this.getDocTypeToUse(bh);
            if (bhType != null) {
                leafTypeToUse = bhType;
            }
        }
        String fileName = node.getName();
        String name = this.getValidNameFromFileName(fileName);
        DocumentModel doc = session.createDocumentModel(parent.getPathAsString(), name, leafTypeToUse);
        for (String facet : this.getFacetsToUse(bh)) {
            doc.addFacet(facet);
        }
        doc.setProperty("dublincore", "title", (Object)node.getName());
        if (blob != null && blob.getLength() > 0L) {
            blob.setFilename(fileName);
            doc.setProperty("file", "content", (Object)blob);
        }
        doc = session.createDocument(doc);
        if (props != null) {
            doc = this.setDocumentProperties(session, props, doc);
        }
        return doc;
    }

    protected String getDocTypeToUse(BlobHolder inBH) {
        Map props;
        String type = null;
        if (inBH != null && (props = inBH.getProperties()) != null && (type = (String)props.get(DOCTYPE_KEY_NAME)) != null && type.isEmpty()) {
            type = null;
        }
        return type;
    }

    protected List<String> getFacetsToUse(BlobHolder inBH) {
        Map props;
        if (inBH != null && (props = inBH.getProperties()) != null) {
            Serializable ob = (Serializable)props.get(FACETS_KEY_NAME);
            if (ob instanceof String) {
                String facet = (String)((Object)ob);
                if (StringUtils.isNotBlank((String)facet)) {
                    return Collections.singletonList(facet);
                }
            } else if (ob != null) {
                return (List)((Object)ob);
            }
        }
        return Collections.emptyList();
    }

    protected String getMimeType(String name) {
        if (name == null) {
            return "application/octet-stream";
        }
        if (name.endsWith(".odp")) {
            return "application/vnd.oasis.opendocument.presentation";
        }
        if (name.endsWith(".otp")) {
            return "application/vnd.oasis.opendocument.presentation-template";
        }
        if (name.endsWith(".otg")) {
            return "application/vnd.oasis.opendocument.graphics-template";
        }
        if (name.endsWith(".odg")) {
            return "application/vnd.oasis.opendocument.graphics";
        }
        if (name.endsWith(".odt")) {
            return "application/vnd.oasis.opendocument.text";
        }
        if (name.endsWith(".ott")) {
            return "application/vnd.oasis.opendocument.text-template";
        }
        if (name.endsWith(".ods")) {
            return "application/vnd.oasis.opendocument.spreadsheet";
        }
        if (name.endsWith(".ots")) {
            return "application/vnd.oasis.opendocument.spreadsheet-template";
        }
        if (name.endsWith(".doc")) {
            return "application/msword";
        }
        if (name.endsWith(".xls")) {
            return "application/vnd.ms-excel";
        }
        if (name.endsWith(".ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (name.endsWith(".xlsx")) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if (name.endsWith(".pptx")) {
            return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        }
        if (name.endsWith(".docx")) {
            return "application/vnd.openxmlformats-officedocument.wordprocessingml.template";
        }
        if (name.endsWith(".tar")) {
            return "application/x-gtar";
        }
        if (name.endsWith(".gz")) {
            return "application/x-gtar";
        }
        if (name.endsWith(".csv")) {
            return "text/csv";
        }
        if (name.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (name.endsWith(".txt")) {
            return "text/plain";
        }
        if (name.endsWith(".html")) {
            return "text/html";
        }
        if (name.endsWith(".xml")) {
            return "text/xml";
        }
        if (name.endsWith(".png")) {
            return "image/png";
        }
        if (name.endsWith(".jpg")) {
            return "image/jpg";
        }
        if (name.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (name.endsWith(".gif")) {
            return "image/gif";
        }
        if (name.endsWith(".zip")) {
            return "application/zip";
        }
        return "application/octet-stream";
    }

    public void setFolderishType(String folderishType) {
        this.folderishType = folderishType;
    }

    public void setLeafType(String leafType) {
        this.leafType = leafType;
    }
}

