/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.source;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.platform.importer.random.DictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.HunspellDictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.RandomTextGenerator;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class RandomTextSourceNode
implements SourceNode {
    private static final Log log = LogFactory.getLog(RandomTextSourceNode.class);
    protected static RandomTextGenerator gen;
    protected static int maxNode;
    protected static boolean nonUniformRepartition;
    public static int maxDepth;
    public static int defaultNbDataNodesPerFolder;
    public static int bigNbNodesFactor;
    public static int smallNbNodesDivider;
    protected static int minGlobalFolders;
    protected static int minFoldersPerNode;
    protected static Integer nbNodes;
    protected static Integer nbFolders;
    protected static Integer nbVisitedFolders;
    protected static Long size;
    protected Random hazard;
    protected String name;
    protected boolean folderish;
    protected int level = 0;
    protected int idx = 0;
    protected static Integer blobSizeInKB;
    protected List<SourceNode> cachedChildren = null;
    public static boolean CACHE_CHILDREN;
    protected boolean onlyText = true;
    protected boolean withProperties = false;
    protected static String[] DC_NATURE;
    protected static String[] DC_SUBJECTS;
    protected static String[] DC_RIGHTS;
    protected static String[] DC_LANGUAGE;
    protected static String[] DC_SOURCE;
    protected static String[] DC_COVERAGE;

    public RandomTextSourceNode(boolean folderish, int level, int idx, boolean onlyText, boolean withProperties) {
        this.folderish = folderish;
        this.hazard = new Random();
        this.level = level;
        this.idx = idx;
        this.onlyText = onlyText;
        this.withProperties = withProperties;
    }

    public RandomTextSourceNode(boolean folderish, int level, int idx, boolean onlyText) {
        this(folderish, level, idx, onlyText, false);
    }

    public static RandomTextSourceNode init(int maxSize) {
        return RandomTextSourceNode.init(maxSize, null, true);
    }

    public static RandomTextSourceNode init(int maxSize, Integer blobSizeInKB, boolean onlyText) {
        return RandomTextSourceNode.init(maxSize, blobSizeInKB, onlyText, false, false, null);
    }

    public static RandomTextSourceNode init(int maxSize, Integer blobSizeInKB, boolean onlyText, boolean nonUniform, boolean withProperties, String lang) {
        return RandomTextSourceNode.init(maxSize, blobSizeInKB, onlyText, new HunspellDictionaryHolder(lang), nonUniform, withProperties);
    }

    public static RandomTextSourceNode init(int maxSize, Integer blobSizeInKB, boolean onlyText, DictionaryHolder dictionaryHolder, boolean nonUniform, boolean withProperties) {
        gen = new RandomTextGenerator(dictionaryHolder);
        gen.prefilCache();
        maxNode = maxSize;
        nbNodes = 0;
        nbFolders = 1;
        nbVisitedFolders = 0;
        size = new Long(0L);
        RandomTextSourceNode.blobSizeInKB = blobSizeInKB;
        minGlobalFolders = maxNode / defaultNbDataNodesPerFolder;
        minFoldersPerNode = 1 + (int)Math.pow(minGlobalFolders, 1.0 / (double)maxDepth);
        nonUniformRepartition = nonUniform;
        return new RandomTextSourceNode(true, 0, 0, onlyText, withProperties);
    }

    protected String getBlobMimeType() {
        if (this.onlyText) {
            return "text/plain";
        }
        return "text/partial";
    }

    private String capitalize(String line) {
        return Character.toUpperCase(line.charAt(0)) + line.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobHolder getBlobHolder() {
        String content = null;
        if (this.folderish) {
            if (this.withProperties) {
                return new SimpleBlobHolderWithProperties((Blob)null, this.getRandomProperties(content));
            }
            return null;
        }
        content = blobSizeInKB == null ? gen.getRandomText() : gen.getRandomText(blobSizeInKB);
        Long l = size;
        synchronized (l) {
            size = size + (long)content.length();
        }
        Blob blob = Blobs.createBlob((String)content, (String)this.getBlobMimeType(), null, (String)(this.getName() + ".txt"));
        if (this.withProperties) {
            return new SimpleBlobHolderWithProperties(blob, this.getRandomProperties(content));
        }
        return new SimpleBlobHolder(blob);
    }

    protected Map<String, Serializable> getRandomProperties(String content) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("dc:title", (Serializable)((Object)this.capitalize(this.getName())));
        if (this.hazard.nextInt(10) == 1) {
            String description = content != null && !content.isEmpty() ? content.substring(0, content.indexOf(32, 40)) : gen.getRandomTitle(this.hazard.nextInt(5) + 1);
            ret.put("dc:description", (Serializable)((Object)this.capitalize(description)));
        }
        ret.put("dc:nature", (Serializable)((Object)this.getGaussian(DC_NATURE)));
        ret.put("dc:subjects", (Serializable)((Object)Arrays.asList(this.getGaussian(DC_SUBJECTS))));
        ret.put("dc:rights", (Serializable)((Object)this.getGaussian(DC_RIGHTS)));
        ret.put("dc:language", (Serializable)((Object)this.getGaussian(DC_LANGUAGE)));
        ret.put("dc:coverage", (Serializable)((Object)this.getGaussian(DC_COVERAGE)));
        ret.put("dc:source", (Serializable)((Object)this.getGaussian(DC_SOURCE)));
        return ret;
    }

    protected String getGaussian(String[] words) {
        double g = Math.abs(this.hazard.nextGaussian() / 4.0);
        g = Math.min(g, 1.0);
        int i = (int)Math.floor(g * (double)(words.length - 1));
        return words[i];
    }

    protected int getMidRandom(int target) {
        return 1 + target / 2 + this.hazard.nextInt(target);
    }

    protected int getNonUniform(int target, boolean folderish) {
        int res;
        int remainder = nbVisitedFolders % 10;
        if (remainder == 8) {
            res = 1 + target / smallNbNodesDivider;
            if (log.isDebugEnabled()) {
                String nodeStr = folderish ? "folderish" : "data";
                log.debug((Object)String.format("### Small number of %s nodes: %d", nodeStr, res));
            }
        } else if (remainder == 9) {
            int factor = folderish ? bigNbNodesFactor / 10 : bigNbNodesFactor;
            res = 1 + target * factor;
            if (log.isDebugEnabled()) {
                String nodeStr = folderish ? "folderish" : "data";
                log.debug((Object)String.format("### Big number of %s nodes: %d", nodeStr, res));
            }
        } else {
            res = this.getMidRandom(target);
        }
        return res;
    }

    protected int getMaxChildren() {
        if (maxNode < nbNodes) {
            return 0;
        }
        int targetRemainingFolders = minGlobalFolders - nbFolders;
        if (targetRemainingFolders <= 0) {
            return defaultNbDataNodesPerFolder + 1;
        }
        int target = (maxNode - nbNodes) / targetRemainingFolders;
        if (target <= 0) {
            return 0;
        }
        if (nonUniformRepartition) {
            return this.getNonUniform(target, false);
        }
        return this.getMidRandom(target);
    }

    protected int getMaxFolderish() {
        if (maxNode <= nbNodes) {
            return 0;
        }
        if (nonUniformRepartition) {
            return this.getNonUniform(minFoldersPerNode, true);
        }
        return this.getMidRandom(minFoldersPerNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SourceNode> getChildren() {
        Integer i3;
        if (!this.folderish) {
            return null;
        }
        if (this.cachedChildren != null) {
            return this.cachedChildren;
        }
        ArrayList<SourceNode> children = new ArrayList<SourceNode>();
        if (nbNodes > maxNode) {
            return children;
        }
        int nbChildren = this.getMaxChildren();
        for (int i2 = 0; i2 < nbChildren; ++i2) {
            children.add(new RandomTextSourceNode(false, this.level, i2, this.onlyText, this.withProperties));
        }
        Integer i2 = nbNodes;
        synchronized (i2) {
            nbNodes = nbNodes + nbChildren;
            if (log.isDebugEnabled()) {
                String nodeStr = nbChildren > 1 ? "nodes" : "node";
                log.debug((Object)String.format("Added %d data %s to %s; data node total count = %d", nbChildren, nodeStr, this.getName(), nbNodes));
            }
        }
        if (!(this.level >= maxDepth || nonUniformRepartition && nbChildren <= 0)) {
            int nbFolderish = this.getMaxFolderish();
            for (int i3 = 0; i3 < nbFolderish; ++i3) {
                children.add(new RandomTextSourceNode(true, this.level + 1, i3, this.onlyText, this.withProperties));
            }
            i3 = nbFolders;
            synchronized (i3) {
                nbFolders = nbFolders + nbFolderish;
                if (log.isDebugEnabled()) {
                    String nodeStr = nbFolderish > 1 ? "nodes" : "node";
                    log.debug((Object)String.format("Added %d folderish %s to %s; folderish node total count = %d", nbFolderish, nodeStr, this.getName(), nbFolders));
                }
            }
        }
        if (CACHE_CHILDREN) {
            this.cachedChildren = children;
        }
        Integer n = nbVisitedFolders;
        synchronized (n) {
            i3 = nbVisitedFolders;
            Integer n2 = nbVisitedFolders = Integer.valueOf(nbVisitedFolders + 1);
            if (log.isDebugEnabled()) {
                String folderStr = nbVisitedFolders > 1 ? "folders" : "folder";
                log.debug((Object)String.format("Visited %d %s", nbVisitedFolders, folderStr));
            }
        }
        return children;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.withProperties) {
                this.name = gen.getRandomTitle(this.hazard.nextInt(3) + 1);
            } else {
                this.name = this.folderish ? "folder" : "file";
                this.name = this.level == 0 && this.folderish ? this.name + "-" + System.currentTimeMillis() % 10000L + this.hazard.nextInt(100) : this.name + "-" + this.level + "-" + this.idx;
            }
        }
        return this.name;
    }

    @Override
    public boolean isFolderish() {
        return this.folderish;
    }

    public static Integer getNbNodes() {
        return nbNodes;
    }

    public static Long getSize() {
        return size;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public String getSourcePath() {
        return null;
    }

    static {
        maxNode = 10000;
        nonUniformRepartition = false;
        maxDepth = 8;
        defaultNbDataNodesPerFolder = 100;
        bigNbNodesFactor = 50;
        smallNbNodesDivider = defaultNbDataNodesPerFolder;
        minGlobalFolders = 0;
        minFoldersPerNode = 0;
        nbNodes = 0;
        nbFolders = 0;
        nbVisitedFolders = 0;
        CACHE_CHILDREN = false;
        DC_NATURE = new String[]{"article", "acknowledgement", "assessment", "application", "order", "contract", "quotation", "fax", "worksheet", "letter", "memo", "note", "notification", "procedure", "report", "internshipReport", "pressReview"};
        DC_SUBJECTS = new String[]{"art/architecture", "art/comics", "art/cinema", "art/culture", "art/danse", "art/music", "sciences/astronomy", "sciences/biology", "sciences/chemistry", "sciences/math", "sciences/physic", "society/ecology", "daily life/gastronomy", "daily life/gardening", "daily life/sport", "technology/it"};
        DC_RIGHTS = new String[]{"OpenContentL", "CC-BY-NC", "CC-BY-ND", "FreeArt", "ODbi", "GNUGPL", "FreeBSD", "CC0"};
        DC_LANGUAGE = new String[]{"IT", "DE", "FR", "US", "EN"};
        DC_SOURCE = new String[]{"internal", "external", "unknown"};
        DC_COVERAGE = new String[]{"europe/France", "europe/Germany", "europe/Italy", "europe/Spain", "oceania/Tonga", "africa/Mali", "asia/Japan", "north-america/United_States_of_America"};
    }
}

