/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.computation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.nuxeo.lib.core.mqueues.computation.Computation;
import org.nuxeo.lib.core.mqueues.computation.ComputationMetadata;
import org.nuxeo.lib.core.mqueues.computation.ComputationMetadataMapping;
import org.nuxeo.lib.core.mqueues.computation.Settings;

public class Topology {
    protected final List<ComputationMetadataMapping> metadataList;
    protected final Map<String, ComputationMetadataMapping> metadataMap = new HashMap<String, ComputationMetadataMapping>();
    protected final Map<String, Supplier<Computation>> supplierMap = new HashMap<String, Supplier<Computation>>();
    protected final DirectedAcyclicGraph<Vertex, DefaultEdge> dag = new DirectedAcyclicGraph(DefaultEdge.class);

    protected Topology(Builder builder) {
        this.supplierMap.putAll(builder.suppliersMap);
        builder.metadataSet.forEach(meta -> this.metadataMap.put(meta.name, (ComputationMetadataMapping)meta));
        this.metadataList = new ArrayList<ComputationMetadataMapping>(builder.metadataSet.size());
        try {
            this.generateDag(builder.metadataSet);
        }
        catch (DirectedAcyclicGraph.CycleFoundException e) {
            throw new IllegalStateException("Cycle found in topology: " + e.getMessage(), e);
        }
    }

    public String toPlantuml() {
        return this.toPlantuml(new Settings(0, 0));
    }

    public String toPlantuml(Settings settings) {
        StringBuilder ret = new StringBuilder();
        ret.append("@startuml\n");
        for (Vertex vertex : this.dag) {
            if (VertexType.COMPUTATION.equals((Object)vertex.getType())) {
                ret.append("node " + vertex.getName() + "\n");
                int concurrency = settings.getConcurrency(vertex.getName());
                if (concurrency <= 0) continue;
                ret.append("note right: x" + concurrency + "\n");
                continue;
            }
            if (!VertexType.STREAM.equals((Object)vertex.getType())) continue;
            ret.append("database " + vertex.getName() + "\n");
        }
        for (DefaultEdge edge : this.dag.edgeSet()) {
            ret.append(((Vertex)this.dag.getEdgeSource((Object)edge)).getName() + "==>" + ((Vertex)this.dag.getEdgeTarget((Object)edge)).getName() + "\n");
        }
        ret.append("@enduml\n");
        return ret.toString();
    }

    protected void generateDag(Set<ComputationMetadataMapping> metadataSet) throws DirectedAcyclicGraph.CycleFoundException {
        for (ComputationMetadata computationMetadata : metadataSet) {
            Vertex streamVertex;
            Vertex computationVertex = new Vertex(VertexType.COMPUTATION, computationMetadata.name);
            this.dag.addVertex((Object)computationVertex);
            if (computationMetadata.ostreams != null) {
                for (String stream : computationMetadata.ostreams) {
                    streamVertex = new Vertex(VertexType.STREAM, stream);
                    this.dag.addVertex((Object)streamVertex);
                    this.dag.addDagEdge((Object)computationVertex, (Object)streamVertex);
                }
            }
            if (computationMetadata.istreams == null) continue;
            for (String streamName : computationMetadata.istreams) {
                streamVertex = new Vertex(VertexType.STREAM, streamName);
                this.dag.addVertex((Object)streamVertex);
                this.dag.addDagEdge((Object)streamVertex, (Object)computationVertex);
            }
        }
        block3: for (Vertex vertex : this.dag) {
            if (!VertexType.COMPUTATION.equals((Object)vertex.getType())) continue;
            for (ComputationMetadataMapping metadata : metadataSet) {
                if (!vertex.getName().equals(metadata.name)) continue;
                this.metadataList.add(metadata);
                continue block3;
            }
        }
    }

    public ComputationMetadataMapping getMetadata(String name) {
        return this.metadataMap.get(name);
    }

    public Supplier<Computation> getSupplier(String name) {
        return this.supplierMap.get(name);
    }

    public boolean isSource(String name) {
        return this.getParents(name).isEmpty();
    }

    public boolean isSink(String name) {
        return this.getChildren(name).isEmpty();
    }

    public Set<String> streamsSet() {
        HashSet<String> ret = new HashSet<String>();
        for (ComputationMetadata computationMetadata : this.metadataList) {
            ret.addAll(computationMetadata.istreams);
            ret.addAll(computationMetadata.ostreams);
        }
        return ret;
    }

    public Set<String> streamsSet(String root) {
        HashSet<String> ret = new HashSet<String>();
        for (String name : this.getDescendantComputationNames(root)) {
            ComputationMetadataMapping meta = this.getMetadata(name);
            ret.addAll(meta.istreams);
            ret.addAll(meta.ostreams);
        }
        return ret;
    }

    public List<ComputationMetadataMapping> metadataList() {
        return this.metadataList;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected Vertex getVertex(String name) {
        Vertex ret;
        if (this.metadataMap.containsKey(name)) {
            ret = new Vertex(VertexType.COMPUTATION, name);
        } else if (this.streamsSet().contains(name)) {
            ret = new Vertex(VertexType.STREAM, name);
        } else {
            throw new IllegalArgumentException("Unknown vertex name: " + name + " for dag: " + this.dag);
        }
        return ret;
    }

    public Set<String> getDescendants(String name) {
        Vertex start = this.getVertex(name);
        return this.dag.getDescendants(this.dag, (Object)start).stream().map(Vertex::getName).collect(Collectors.toSet());
    }

    public Set<String> getDescendantComputationNames(String name) {
        Vertex start = this.getVertex(name);
        return this.dag.getDescendants(this.dag, (Object)start).stream().filter(vertex -> vertex.type == VertexType.COMPUTATION).map(vertex -> vertex.name).collect(Collectors.toSet());
    }

    public Set<String> getChildren(String name) {
        Vertex start = this.getVertex(name);
        return this.dag.outgoingEdgesOf((Object)start).stream().map(edge -> ((Vertex)this.dag.getEdgeTarget(edge)).getName()).collect(Collectors.toSet());
    }

    public Set<String> getChildrenComputationNames(String name) {
        Vertex start = this.getVertex(name);
        Set<String> children = this.getChildren(name);
        if (start.type == VertexType.STREAM) {
            return children;
        }
        HashSet<String> ret = new HashSet<String>();
        children.forEach(child -> ret.addAll(this.getChildren((String)child)));
        return ret;
    }

    public Set<String> getParents(String name) {
        Vertex start = this.getVertex(name);
        return this.dag.incomingEdgesOf((Object)start).stream().map(edge -> ((Vertex)this.dag.getEdgeSource(edge)).getName()).collect(Collectors.toSet());
    }

    public Set<String> getParentComputationsNames(String name) {
        Vertex start = this.getVertex(name);
        Set<String> parents = this.getParents(name);
        if (start.type == VertexType.STREAM) {
            return parents;
        }
        HashSet<String> ret = new HashSet<String>();
        parents.forEach(parent -> ret.addAll(this.getParents((String)parent)));
        return ret;
    }

    public Set<String> getAncestorComputationNames(String name) {
        Set ancestors = this.dag.getAncestors(this.dag, (Object)new Vertex(VertexType.COMPUTATION, name));
        return ancestors.stream().filter(vertex -> vertex.type == VertexType.COMPUTATION).map(vertex -> vertex.name).collect(Collectors.toSet());
    }

    public Set<String> getAncestors(String name) {
        Vertex start = this.getVertex(name);
        return this.dag.getAncestors(this.dag, (Object)start).stream().map(Vertex::getName).collect(Collectors.toSet());
    }

    public Set<String> getRoots() {
        HashSet<String> ret = new HashSet<String>();
        for (Vertex vertex : this.dag) {
            if (!this.dag.getAncestors(this.dag, (Object)vertex).isEmpty()) continue;
            ret.add(vertex.getName());
        }
        return ret;
    }

    public DirectedAcyclicGraph<Vertex, DefaultEdge> getDag() {
        return this.dag;
    }

    public class Vertex {
        protected final String name;
        protected final VertexType type;

        public Vertex(VertexType type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public VertexType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vertex myVertex = (Vertex)o;
            if (!this.name.equals(myVertex.name)) {
                return false;
            }
            return this.type == myVertex.type;
        }

        public String toString() {
            return "Vertex{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }

    public static class Builder {
        final Set<ComputationMetadataMapping> metadataSet = new HashSet<ComputationMetadataMapping>();
        final Map<String, Supplier<Computation>> suppliersMap = new HashMap<String, Supplier<Computation>>();

        public Builder addComputation(Supplier<Computation> supplier, List<String> mapping) {
            HashMap<String, String> map = new HashMap<String, String>(mapping.size());
            mapping.stream().filter(m -> m.contains(":")).forEach(m -> map.put(m.split(":")[0], m.split(":")[1]));
            ComputationMetadataMapping meta = new ComputationMetadataMapping(supplier.get().metadata(), map);
            this.metadataSet.add(meta);
            this.suppliersMap.put(meta.name, supplier);
            return this;
        }

        public Topology build() {
            return new Topology(this);
        }
    }

    protected static enum VertexType {
        COMPUTATION,
        STREAM;

    }
}

