/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.computation.mqueue;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.core.mqueues.computation.Computation;
import org.nuxeo.lib.core.mqueues.computation.ComputationMetadataMapping;
import org.nuxeo.lib.core.mqueues.computation.Watermark;
import org.nuxeo.lib.core.mqueues.computation.mqueue.MQComputationRunner;
import org.nuxeo.lib.core.mqueues.mqueues.MQManager;
import org.nuxeo.lib.core.mqueues.mqueues.MQPartition;

public class MQComputationPool {
    private static final Log log = LogFactory.getLog(MQComputationPool.class);
    protected final ComputationMetadataMapping metadata;
    protected final int threads;
    protected final MQManager manager;
    protected final Supplier<Computation> supplier;
    protected final List<List<MQPartition>> defaultAssignments;
    protected ExecutorService threadPool;
    protected final List<MQComputationRunner> runners;

    public MQComputationPool(Supplier<Computation> supplier, ComputationMetadataMapping metadata, List<List<MQPartition>> defaultAssignments, MQManager manager) {
        this.supplier = supplier;
        this.manager = manager;
        this.metadata = metadata;
        this.threads = defaultAssignments.size();
        this.defaultAssignments = defaultAssignments;
        this.runners = new ArrayList<MQComputationRunner>(this.threads);
    }

    public String getComputationName() {
        return this.metadata.name();
    }

    public void start() {
        log.info((Object)(this.metadata.name() + ": Starting pool"));
        this.threadPool = Executors.newFixedThreadPool(this.threads, new NamedThreadFactory(this.metadata.name() + "Pool"));
        this.defaultAssignments.forEach(assignments -> {
            MQComputationRunner runner = new MQComputationRunner(this.supplier, this.metadata, (List<MQPartition>)assignments, this.manager);
            this.threadPool.submit(runner);
            this.runners.add(runner);
        });
        this.threadPool.shutdown();
        log.debug((Object)(this.metadata.name() + ": Pool started, threads: " + this.threads));
    }

    public boolean waitForAssignments(Duration timeout) throws InterruptedException {
        log.info((Object)(this.metadata.name() + ": Wait for partitions assignments"));
        if (this.threadPool == null || this.threadPool.isTerminated()) {
            return true;
        }
        for (MQComputationRunner runner : this.runners) {
            if (runner.waitForAssignments(timeout)) continue;
            return false;
        }
        return true;
    }

    public boolean drainAndStop(Duration timeout) {
        if (this.threadPool == null || this.threadPool.isTerminated()) {
            return true;
        }
        log.info((Object)(this.metadata.name() + ": Draining"));
        this.runners.forEach(MQComputationRunner::drain);
        boolean ret = this.awaitPoolTermination(timeout);
        this.stop(Duration.ofSeconds(1L));
        return ret;
    }

    public boolean stop(Duration timeout) {
        if (this.threadPool == null || this.threadPool.isTerminated()) {
            return true;
        }
        log.info((Object)(this.metadata.name() + ": Stopping"));
        this.runners.forEach(MQComputationRunner::stop);
        boolean ret = this.awaitPoolTermination(timeout);
        this.shutdown();
        return ret;
    }

    public void shutdown() {
        if (this.threadPool != null && !this.threadPool.isTerminated()) {
            log.info((Object)(this.metadata.name() + ": Shutting down"));
            this.threadPool.shutdownNow();
            try {
                this.threadPool.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.warn((Object)(this.metadata.name() + ": Interrupted in shutdown"));
                Thread.currentThread().interrupt();
            }
        }
        this.runners.clear();
        this.threadPool = null;
    }

    protected boolean awaitPoolTermination(Duration timeout) {
        try {
            if (!this.threadPool.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                log.warn((Object)(this.metadata.name() + ": Timeout on wait for pool termination"));
                return false;
            }
        }
        catch (InterruptedException e) {
            log.warn((Object)(this.metadata.name() + ": Interrupted while waiting for pool termination"));
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    public long getLowWatermark() {
        Set watermarks = this.runners.stream().map(MQComputationRunner::getLowWatermark).filter(wm -> wm.getValue() > 1L).collect(Collectors.toSet());
        long ret = watermarks.stream().filter(wm -> !wm.isCompleted()).map(Watermark::getValue).min(Comparator.naturalOrder()).orElse(0L);
        boolean pending = true;
        if (ret == 0L) {
            pending = false;
            ret = watermarks.stream().filter(Watermark::isCompleted).map(Watermark::getValue).max(Comparator.naturalOrder()).orElse(0L);
        }
        if (log.isTraceEnabled() && ret > 0L) {
            log.trace((Object)(this.metadata.name() + ": low: " + ret + " " + (pending ? "Pending" : "Completed")));
        }
        return ret;
    }

    protected static class NamedThreadFactory
    implements ThreadFactory {
        protected final AtomicInteger count = new AtomicInteger(0);
        protected final String prefix;

        public NamedThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, String.format("%s-%02d", this.prefix, this.count.getAndIncrement()));
            t.setUncaughtExceptionHandler((t1, e) -> log.error((Object)("Uncaught exception: " + e.getMessage()), e));
            return t;
        }
    }
}

