/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.mqueues;

public class MQLag {
    protected final long lowerOffset;
    protected final long upperOffset;
    protected final long lag;
    protected final long upper;

    public MQLag(long lowerOffset, long upperOffset) {
        this(lowerOffset, upperOffset, upperOffset - lowerOffset, upperOffset);
    }

    public MQLag(long lowerOffset, long upperOffset, long lag, long upper) {
        this.lowerOffset = lowerOffset;
        this.upperOffset = upperOffset;
        this.upper = upper;
        this.lag = lag;
    }

    public long lag() {
        return this.lag;
    }

    public long upper() {
        return this.upper;
    }

    public long lower() {
        return this.upper - this.lag;
    }

    public long upperOffset() {
        return this.upperOffset;
    }

    public long lowerOffset() {
        return this.lowerOffset;
    }

    public static MQLag of(long lowerOffset, long upperOffset) {
        return new MQLag(lowerOffset, upperOffset);
    }

    public static MQLag of(long lag) {
        return new MQLag(0L, lag, lag, lag);
    }

    public String toString() {
        return "MQLag{lower=" + this.lower() + ", upper=" + this.upper + ", lag=" + this.lag + ", lowerOffset=" + this.lowerOffset + ", upperOffset=" + this.upperOffset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MQLag lag1 = (MQLag)o;
        return this.lag == lag1.lag;
    }

    public int hashCode() {
        return (int)(this.lag ^ this.lag >>> 32);
    }
}

