/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.mqueues.chronicle;

import java.io.File;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChronicleMQOffsetTracker
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(ChronicleMQOffsetTracker.class);
    protected final SingleChronicleQueue offsetQueue;
    protected final int queueIndex;
    protected static final String OFFSET_QUEUE_PREFIX = "offset-";
    protected long lastCommittedOffset;

    public ChronicleMQOffsetTracker(String basePath, int queue, String group) {
        this.queueIndex = queue;
        File offsetFile = new File(basePath, OFFSET_QUEUE_PREFIX + group);
        this.offsetQueue = SingleChronicleQueueBuilder.binary((File)offsetFile).build();
    }

    public static boolean isOffsetTracker(String dirName) {
        return dirName.startsWith(OFFSET_QUEUE_PREFIX);
    }

    public static String getGroupFromDirectory(String dirName) {
        if (!ChronicleMQOffsetTracker.isOffsetTracker(dirName)) {
            throw new IllegalArgumentException(String.format("Invalid directory %s, not an offset tracker", dirName));
        }
        return dirName.replaceFirst(OFFSET_QUEUE_PREFIX, "");
    }

    public long getLastCommittedOffset() {
        if (this.lastCommittedOffset > 0L) {
            return this.lastCommittedOffset;
        }
        return this.readLastCommittedOffset();
    }

    public long readLastCommittedOffset() {
        boolean hasNext;
        ExcerptTailer offsetTailer;
        try {
            offsetTailer = this.offsetQueue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
        }
        catch (IllegalStateException e) {
            log.warn((Object)String.format("Fail to reach the end of offset queue: %s because of: %s, retrying.", this.offsetQueue.file().getAbsolutePath(), e.getMessage()));
            offsetTailer = this.offsetQueue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
        }
        long[] offset = new long[]{0L};
        do {
            hasNext = offsetTailer.readBytes(b -> {
                int queue = b.readInt();
                long off = b.readLong();
                long stamp = b.readLong();
                if (this.queueIndex == queue) {
                    offset[0] = off;
                }
            });
        } while (offset[0] == 0L && hasNext);
        return offset[0];
    }

    public void commit(long offset) {
        ExcerptAppender appender = this.offsetQueue.acquireAppender();
        appender.writeBytes(b -> b.writeInt(this.queueIndex).writeLong(offset).writeLong(System.currentTimeMillis()));
        this.lastCommittedOffset = offset;
    }

    @Override
    public void close() {
        this.offsetQueue.close();
    }
}

