/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.mqueues.internals;

import org.nuxeo.lib.core.mqueues.mqueues.MQOffset;
import org.nuxeo.lib.core.mqueues.mqueues.MQPartition;

public class MQOffsetImpl
implements MQOffset {
    protected MQPartition partition;
    protected final long offset;

    public MQOffsetImpl(MQPartition partition, long offset) {
        this.partition = partition;
        this.offset = offset;
    }

    public MQOffsetImpl(String name, int partition, long offset) {
        this.partition = MQPartition.of(name, partition);
        this.offset = offset;
    }

    @Override
    public MQPartition partition() {
        return this.partition;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    public String toString() {
        return String.format("%s:+%d", this.partition, this.offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MQOffsetImpl offsetImpl = (MQOffsetImpl)o;
        if (!this.partition.equals(offsetImpl.partition)) {
            return false;
        }
        return this.offset == offsetImpl.offset;
    }

    public int hashCode() {
        int result = this.partition != null ? this.partition.hashCode() : 0;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }

    @Override
    public int compareTo(MQOffset o) {
        if (this == o) {
            return 0;
        }
        if (o == null || this.getClass() != o.getClass()) {
            throw new IllegalArgumentException("Can not compare offsets with different classes");
        }
        MQOffsetImpl offsetImpl = (MQOffsetImpl)o;
        if (this.partition.equals(offsetImpl.partition)) {
            throw new IllegalArgumentException("Can not compare offsets from different partitions");
        }
        return (int)(this.offset - offsetImpl.offset);
    }
}

