/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.pattern.consumer;

import java.util.List;

public class ConsumerStatus {
    public final String consumerId;
    public final long startTime;
    public final long stopTime;
    public final long accepted;
    public final long committed;
    public final long batchFailure;
    public final long batchCommit;
    public final boolean fail;

    public ConsumerStatus(String consumerId, long accepted, long committed, long batchCommit, long batchFailure, long startTime, long stopTime, boolean fail) {
        this.consumerId = consumerId;
        this.accepted = accepted;
        this.committed = committed;
        this.batchCommit = batchCommit;
        this.batchFailure = batchFailure;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.fail = fail;
    }

    public String toString() {
        if (this.fail) {
            return "Consumer status FAILURE";
        }
        double elapsed = (double)(this.stopTime - this.startTime) / 1000.0;
        double mps = elapsed != 0.0 ? (double)this.committed / elapsed : 0.0;
        return String.format("Consumer %s status: accepted (include retries): %s, committed: %d, batch: %d, batchFailure: %d, elapsed: %.2fs, throughput: %.2f msg/s.", this.consumerId, this.accepted, this.committed, this.batchCommit, this.batchFailure, elapsed, mps);
    }

    static String toString(List<ConsumerStatus> stats) {
        long startTime = stats.stream().mapToLong(r -> r.startTime).min().orElse(0L);
        long stopTime = stats.stream().mapToLong(r -> r.stopTime).max().orElse(0L);
        double elapsed = (double)(stopTime - startTime) / 1000.0;
        long committed = stats.stream().mapToLong(r -> r.committed).sum();
        double mps = elapsed != 0.0 ? (double)committed / elapsed : 0.0;
        int consumers = stats.size();
        long failures = stats.stream().filter(s -> s.fail).count();
        return String.format("Consumers status: threads: %d, failure %d, messages committed: %d, elapsed: %.2fs, throughput: %.2f msg/s", consumers, failures, committed, elapsed, mps);
    }
}

