/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class FileWithNonHeritedIndividalMetaDataSourceNode
extends FileSourceNode {
    private static final Log log = LogFactory.getLog(FileWithNonHeritedIndividalMetaDataSourceNode.class);
    public static final String PROPERTY_FILE_SUFIX = ".properties";
    protected static Pattern numPattern = Pattern.compile("([0-9\\,\\.\\+\\-]+)");
    public static String LIST_SEPARATOR = "|";
    public static String REGEXP_LIST_SEPARATOR = "\\|";
    public static String ARRAY_SEPARATOR = "||";
    public static String REGEXP_ARRAY_SEPARATOR = "\\|\\|";

    public FileWithNonHeritedIndividalMetaDataSourceNode(File file) {
        super(file);
    }

    public FileWithNonHeritedIndividalMetaDataSourceNode(String path) {
        super(path);
    }

    @Override
    public List<SourceNode> getChildren() {
        File[] listFiles;
        ArrayList<SourceNode> children = new ArrayList<SourceNode>();
        for (File child : listFiles = this.file.listFiles()) {
            if (this.isPropertyFile(child)) continue;
            children.add(new FileWithNonHeritedIndividalMetaDataSourceNode(child));
        }
        return children;
    }

    protected boolean isPropertyFile(File file) {
        return file.getName().contains(PROPERTY_FILE_SUFIX);
    }

    @Override
    public BlobHolder getBlobHolder() throws IOException {
        Object bh = null;
        String metadataFilename = this.file.getParent() + File.separator + FileWithNonHeritedIndividalMetaDataSourceNode.getFileNameNoExt(this.file) + PROPERTY_FILE_SUFIX;
        File metadataFile = new File(metadataFilename);
        bh = metadataFile.exists() ? new SimpleBlobHolderWithProperties(Blobs.createBlob((File)this.file), this.loadPropertyFile(metadataFile)) : new SimpleBlobHolder(Blobs.createBlob((File)this.file));
        return bh;
    }

    protected Map<String, Serializable> loadPropertyFile(File propertyFile) {
        Properties mdProperties = new Properties();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        try {
            mdProperties.load(new FileInputStream(propertyFile));
            Enumeration<?> names = mdProperties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, this.parseFromString(mdProperties.getProperty(name)));
            }
        }
        catch (IOException e) {
            log.error((Object)("Unable to read property file " + propertyFile), (Throwable)e);
        }
        return map;
    }

    protected Serializable parseFromString(String value) {
        Object prop = value;
        if (value.contains(ARRAY_SEPARATOR)) {
            prop = value.split(REGEXP_ARRAY_SEPARATOR);
        } else if (value.contains(LIST_SEPARATOR)) {
            String[] parts;
            ArrayList<Serializable> lstprop = new ArrayList<Serializable>();
            for (String part : parts = value.split(REGEXP_LIST_SEPARATOR)) {
                lstprop.add(this.parseFromString(part));
            }
            prop = lstprop;
        }
        return prop;
    }
}

