/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="config")
public class ConfigDescriptor {
    @XNode(value="@name")
    public String name;
    @XNode(value="@type")
    public String type;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();
    @XNodeList(value="mqueue", type=ArrayList.class, componentType=MQueueDescriptor.class)
    public List<MQueueDescriptor> mQueues = new ArrayList<MQueueDescriptor>(0);

    public String getName() {
        return this.name;
    }

    public String getType() {
        if ("kafka".equalsIgnoreCase(this.type)) {
            return "kafka";
        }
        return "chronicle";
    }

    public String getOption(String key, String defaultValue) {
        return this.options.getOrDefault(key, defaultValue);
    }

    public Map<String, Integer> getMQueuesToCreate() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        this.mQueues.forEach(d -> ret.put(d.name, d.size));
        return ret;
    }

    @XObject(value="mqueue")
    public static class MQueueDescriptor {
        public static final Integer DEFAULT_PARTITIONS = 4;
        @XNode(value="@name")
        public String name;
        @XNode(value="@size")
        public Integer size = DEFAULT_PARTITIONS;
    }
}

