/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.audit;

import java.io.Externalizable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.io.registry.MarshallerHelper;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.mqueues.MQService;
import org.nuxeo.lib.core.mqueues.computation.Record;
import org.nuxeo.lib.core.mqueues.mqueues.MQAppender;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class AuditEventListener
implements EventListener,
Synchronization {
    private static final Log log = LogFactory.getLog(AuditEventListener.class);
    protected static final ThreadLocal<Boolean> isEnlisted = ThreadLocal.withInitial(() -> Boolean.FALSE);
    protected static final ThreadLocal<List<LogEntry>> entries = ThreadLocal.withInitial(ArrayList::new);
    public static final String STREAM_CONFIG = "audit";
    public static final String STREAM_NAME = "audit";

    public void handleEvent(Event event) {
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        if (logger == null) {
            return;
        }
        if (!isEnlisted.get().booleanValue()) {
            isEnlisted.set(this.registerSynchronization(this));
            entries.get().clear();
            if (log.isDebugEnabled()) {
                log.debug((Object)"AuditEventListener collecting entries for the tx");
            }
        }
        if (logger.getAuditableEventNames().contains(event.getName())) {
            entries.get().add(logger.buildEntryFromEvent(event));
        }
        if (!isEnlisted.get().booleanValue()) {
            this.afterCompletion(3);
        }
    }

    public void beforeCompletion() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("AuditEventListener going to write %d entries.", entries.get().size()));
        }
    }

    public void afterCompletion(int status) {
        try {
            if (entries.get().isEmpty() || 1 == status || 4 == status) {
                return;
            }
            this.writeEntries();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("AuditEventListener writes %d entries.", entries.get().size()));
            }
        }
        finally {
            isEnlisted.set(false);
            entries.get().clear();
        }
    }

    protected void writeEntries() {
        entries.get().forEach(this::writeEntry);
    }

    protected void writeEntry(LogEntry entry) {
        String json = this.asJson(entry);
        if (json == null) {
            return;
        }
        MQService service = (MQService)Framework.getService(MQService.class);
        MQAppender appender = service.getManager("audit").getAppender("audit");
        appender.append(0, (Externalizable)Record.of((String)String.valueOf(entry.getId()), (byte[])json.getBytes()));
    }

    protected String asJson(LogEntry entry) {
        if (entry == null) {
            return null;
        }
        RenderingContext ctx = RenderingContext.CtxBuilder.get();
        try {
            return MarshallerHelper.objectToJson((Object)entry, (RenderingContext)ctx);
        }
        catch (IOException e) {
            log.warn((Object)("Unable to translate entry into json, eventId:" + entry.getEventId() + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected boolean registerSynchronization(Synchronization sync) {
        try {
            TransactionManager tm = TransactionHelper.lookupTransactionManager();
            if (tm != null) {
                if (tm.getTransaction() != null) {
                    tm.getTransaction().registerSynchronization(sync);
                    return true;
                }
                return false;
            }
            log.error((Object)"Unable to register synchronization : no TransactionManager");
            return false;
        }
        catch (IllegalStateException | NamingException | RollbackException | SystemException e) {
            log.error((Object)"Unable to register synchronization", e);
            return false;
        }
    }
}

