/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.importer.consumer;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.platform.mqueues.importer.consumer.BlobInfoWriter;
import org.nuxeo.ecm.platform.mqueues.importer.message.BlobMessage;
import org.nuxeo.lib.core.mqueues.pattern.consumer.AbstractConsumer;
import org.nuxeo.runtime.api.Framework;

public class BlobMessageConsumer
extends AbstractConsumer<BlobMessage> {
    protected static final AtomicInteger consumerCounter = new AtomicInteger(0);
    protected final BlobProvider blobProvider;
    protected final String blobProviderName;
    protected final BlobInfoWriter blobInfoWriter;

    public BlobMessageConsumer(String consumerId, String blobProviderName, BlobInfoWriter blobInfoWriter) {
        super(consumerId);
        this.blobProviderName = blobProviderName;
        this.blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blobProviderName);
        if (this.blobProvider == null) {
            throw new IllegalArgumentException("Invalid blob provider: " + blobProviderName);
        }
        this.blobInfoWriter = blobInfoWriter;
    }

    public void begin() {
    }

    public void accept(BlobMessage message) {
        try {
            Object blob = message.getPath() != null ? new FileBlob(new File(message.getPath())) : new StringBlob(message.getContent(), null, null, null);
            String digest = this.blobProvider.writeBlob((Blob)blob);
            long length = blob.getLength();
            this.saveBlobInfo(message, digest, length);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid blob: " + message, e);
        }
    }

    protected void saveBlobInfo(BlobMessage message, String digest, long length) throws IOException {
        BlobInfo bi = new BlobInfo();
        bi.digest = digest;
        bi.key = this.blobProviderName + ":" + bi.digest;
        bi.length = length;
        bi.filename = message.getFilename();
        bi.mimeType = message.getMimetype();
        bi.encoding = message.getEncoding();
        this.blobInfoWriter.save(null, bi);
    }

    public void commit() {
    }

    public void rollback() {
    }
}

