/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.importer.producer;

import java.time.Duration;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.platform.mqueues.importer.message.BlobInfoMessage;
import org.nuxeo.ecm.platform.mqueues.importer.message.DocumentMessage;
import org.nuxeo.ecm.platform.mqueues.importer.producer.BlobInfoFetcher;
import org.nuxeo.lib.core.mqueues.mqueues.MQRecord;
import org.nuxeo.lib.core.mqueues.mqueues.MQTailer;

public class RandomMQBlobInfoFetcher
implements BlobInfoFetcher {
    protected static final int READ_DELAY_MS = 10;
    protected final MQTailer<BlobInfoMessage> tailer;

    public RandomMQBlobInfoFetcher(MQTailer<BlobInfoMessage> blobInfoTailer) {
        this.tailer = blobInfoTailer;
    }

    @Override
    public BlobInfo get(DocumentMessage.Builder builder) {
        MQRecord record;
        try {
            record = this.tailer.read(Duration.ofMillis(10L));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (record == null) {
            this.tailer.toStart();
            return this.get(builder);
        }
        return (BlobInfo)record.message();
    }

    @Override
    public void close() throws Exception {
        this.tailer.close();
    }
}

