/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.kafka;

import java.util.Properties;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="kafkaConfig")
public class KafkaConfigDescriptor {
    protected static final String RANDOM_TOPIC_PREFIX = "RANDOM()";
    @XNode(value="@name")
    public String name;
    @XNode(value="@zkServers")
    public String zkServers;
    @XNode(value="@topicPrefix")
    public String topicPrefix;
    @XNode(value="producerProperties")
    protected ProducerProperties producerProperties;
    @XNode(value="consumerProperties")
    protected ConsumerProperties consumerProperties;

    public Properties getProducerProperties() {
        if (this.producerProperties == null) {
            return new Properties();
        }
        return this.producerProperties.properties;
    }

    public Properties getConsumerProperties() {
        if (this.consumerProperties == null) {
            return new Properties();
        }
        return this.consumerProperties.properties;
    }

    public String getTopicPrefix() {
        if (this.topicPrefix == null) {
            return "";
        }
        if (RANDOM_TOPIC_PREFIX.equals(this.topicPrefix)) {
            this.topicPrefix = "nuxeo-test-" + System.currentTimeMillis() + "-";
        }
        return this.topicPrefix;
    }

    @XObject(value="consumerProperties")
    public static class ConsumerProperties {
        @XNodeMap(value="property", key="@name", type=Properties.class, componentType=String.class)
        protected Properties properties = new Properties();
    }

    @XObject(value="producerProperties")
    public static class ProducerProperties {
        @XNodeMap(value="property", key="@name", type=Properties.class, componentType=String.class)
        protected Properties properties = new Properties();
    }
}

