/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.time.Duration;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PeriodAndDuration {
    public static final PeriodAndDuration ZERO = new PeriodAndDuration(Period.ZERO, Duration.ZERO);
    protected static final Pattern PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)Y)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?", 2);
    protected static final int SECONDS_PER_MINUTE = 60;
    protected static final int SECONDS_PER_HOUR = 3600;
    public final Period period;
    public final Duration duration;

    public PeriodAndDuration(Period period, Duration duration) {
        Objects.requireNonNull(period, "period");
        Objects.requireNonNull(duration, "duration");
        this.period = period;
        this.duration = duration;
    }

    public PeriodAndDuration(Period period) {
        this(period, Duration.ZERO);
    }

    public PeriodAndDuration(Duration duration) {
        this(Period.ZERO, duration);
    }

    public static PeriodAndDuration parse(String text) {
        Objects.requireNonNull(text, "text");
        Matcher matcher = PATTERN.matcher(text);
        if (matcher.matches() && !"T".equals(matcher.group(5))) {
            boolean negate = "-".equals(matcher.group(1));
            String yearMatch = matcher.group(2);
            String monthMatch = matcher.group(3);
            String dayMatch = matcher.group(4);
            String hourMatch = matcher.group(6);
            String minuteMatch = matcher.group(7);
            String secondMatch = matcher.group(8);
            String fractionMatch = matcher.group(9);
            if (yearMatch != null || monthMatch != null || dayMatch != null || hourMatch != null || minuteMatch != null || secondMatch != null) {
                int years = PeriodAndDuration.parseInt(yearMatch, text, "years");
                int months = PeriodAndDuration.parseInt(monthMatch, text, "months");
                int days = PeriodAndDuration.parseInt(dayMatch, text, "days");
                long hoursAsSecs = PeriodAndDuration.parseNumber(hourMatch, 3600, text, "hours");
                long minsAsSecs = PeriodAndDuration.parseNumber(minuteMatch, 60, text, "minutes");
                long seconds = PeriodAndDuration.parseNumber(secondMatch, 1, text, "seconds");
                int nanos = PeriodAndDuration.parseFraction(fractionMatch, Long.signum(seconds), text);
                try {
                    Period period = Period.of(years, months, days);
                    if (negate) {
                        period = period.negated();
                    }
                    seconds = Math.addExact(hoursAsSecs, Math.addExact(minsAsSecs, seconds));
                    Duration duration = Duration.ofSeconds(seconds, nanos);
                    if (negate) {
                        duration = duration.negated();
                    }
                    return new PeriodAndDuration(period, duration);
                }
                catch (ArithmeticException e) {
                    throw new DateTimeParseException("Text cannot be parsed to a PeriodAndDuration: overflow", text, 0, e);
                }
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a PeriodAndDuration", text, 0);
    }

    protected static int parseInt(String string, String text, String errorText) {
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new DateTimeParseException("Text cannot be parsed to a PeriodAndDuration: " + errorText, text, 0, e);
        }
    }

    protected static long parseNumber(String string, int multiplier, String text, String errorText) {
        if (string == null) {
            return 0L;
        }
        try {
            long val = Long.parseLong(string);
            return Math.multiplyExact(val, (long)multiplier);
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new DateTimeParseException("Text cannot be parsed to a PeriodAndDuration: " + errorText, text, 0, e);
        }
    }

    protected static int parseFraction(String string, int sign, String text) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        try {
            string = (string + "000000000").substring(0, 9);
            return Integer.parseInt(string) * sign;
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new DateTimeParseException("Text cannot be parsed to a PeriodAndDuration: fraction", text, 0, e);
        }
    }

    public String toString() {
        int i;
        if (this.period.isZero()) {
            if (this.duration.getSeconds() < 0L) {
                return "-" + this.duration.negated().toString();
            }
            return this.duration.toString();
        }
        if (this.duration.isZero()) {
            if (this.period.getYears() <= 0 && this.period.getMonths() <= 0 && this.period.getDays() <= 0) {
                return "-" + this.period.negated().toString();
            }
            return this.period.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (this.duration.getSeconds() <= 0L && this.period.getYears() <= 0 && this.period.getMonths() <= 0 && this.period.getDays() <= 0) {
            sb.append("-");
            sb.append(this.period.negated().toString());
            i = sb.length();
            sb.append(this.duration.negated().toString());
        } else {
            sb.append(this.period.toString());
            i = sb.length();
            sb.append(this.duration.toString());
        }
        sb.deleteCharAt(i);
        return sb.toString();
    }
}

