/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.nio.charset.StandardCharsets;
import org.nuxeo.common.utils.UserAgentMatcher;

public class RFC2231 {
    private static final String MIME_SPECIALS = "()<>@,;:\\\"/[]?=\t ";
    private static final String RFC2231_SPECIALS = "*'%()<>@,;:\\\"/[]?=\t ";
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    private RFC2231() {
    }

    public static void percentEscape(StringBuilder buf, String value) {
        byte[] bytes;
        for (byte b : bytes = value.getBytes(StandardCharsets.UTF_8)) {
            if (b < 43 || b == 59 || b == 44 || b == 92 || b > 122) {
                buf.append('%');
                String s = Integer.toHexString(b & 0xFF).toUpperCase();
                if (s.length() < 2) {
                    buf.append('0');
                }
                buf.append(s);
                continue;
            }
            buf.append((char)b);
        }
    }

    protected static void encodeRFC2231(StringBuilder buf, String value) {
        int originalLength = buf.length();
        buf.append("*=UTF-8''");
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        boolean encoded = false;
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            if (c <= 32 || c >= 127 || RFC2231_SPECIALS.indexOf(c) != -1) {
                buf.append('%');
                buf.append(HEX_DIGITS[c >> 4]);
                buf.append(HEX_DIGITS[c & 0xF]);
                encoded = true;
                continue;
            }
            buf.append((char)c);
        }
        if (!encoded) {
            buf.setLength(originalLength);
            buf.append('=');
            buf.append(value);
        }
    }

    public static String encodeContentDisposition(String filename, boolean inline, String userAgent) {
        StringBuilder buf = new StringBuilder();
        buf.append(inline ? "inline" : "attachment");
        buf.append("; filename");
        if (userAgent == null) {
            userAgent = "";
        }
        if (UserAgentMatcher.isMSIE6or7(userAgent)) {
            buf.append("=");
            RFC2231.percentEscape(buf, filename);
        } else {
            RFC2231.encodeRFC2231(buf, filename);
        }
        return buf.toString();
    }
}

