/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import java.io.IOException;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.runtime.api.Framework;

public class JsonFactoryManagerImpl
implements JsonFactoryManager {
    public static final String REST_STACK_DISPLAY = "org.nuxeo.rest.stack.enable";
    protected boolean stackDisplay = Framework.isBooleanPropertyTrue((String)"org.nuxeo.rest.stack.enable");
    private JsonFactory factory;

    @Override
    public JsonFactory getJsonFactory() {
        if (this.factory == null) {
            this.factory = this.createFactory();
        }
        return this.factory;
    }

    @Override
    public JsonFactory createFactory() {
        JsonFactory factory = new JsonFactory();
        ObjectMapper oc = new ObjectMapper(factory);
        SimpleModule module = new SimpleModule("webengine", Version.unknownVersion()){

            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanSerializerModifier(new BeanSerializerModifier(){

                    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                        if (!Throwable.class.isAssignableFrom(beanDesc.getBeanClass())) {
                            return super.modifySerializer(config, beanDesc, serializer);
                        }
                        return new ThrowableSerializer((BeanSerializer)serializer);
                    }
                });
            }
        };
        oc.registerModule((Module)module);
        factory.setCodec((ObjectCodec)oc);
        return factory;
    }

    @Override
    public boolean toggleStackDisplay() {
        this.stackDisplay = !this.stackDisplay;
        return this.stackDisplay;
    }

    @Override
    public boolean isStackDisplay() {
        return this.stackDisplay;
    }

    private static class ThrowableSerializer
    extends BeanSerializer {
        public ThrowableSerializer(BeanSerializer src) {
            super((BeanSerializerBase)src);
        }

        protected void serializeFields(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            this.serializeClassName(bean, jgen, provider);
            super.serializeFields(bean, jgen, provider);
        }

        protected void serializeFieldsFiltered(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            this.serializeClassName(bean, jgen, provider);
            super.serializeFieldsFiltered(bean, jgen, provider);
        }

        protected void serializeClassName(Object bean, JsonGenerator jgen, SerializerProvider provider) throws JsonGenerationException, IOException {
            jgen.writeFieldName("className");
            jgen.writeString(bean.getClass().getName());
        }
    }
}

