/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import javax.ws.rs.Path;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.WebEngine;

@XObject(value="resource", order={"@path", "@class"})
public class ResourceBinding {
    @XNode(value="@path")
    public String path;
    @XNode(value="@singleton")
    public boolean singleton = false;
    private boolean hasUserPath = false;
    @XNode(value="@class")
    public String className;
    public Class<?> clazz;

    public ResourceBinding() {
    }

    public ResourceBinding(String path, Class<?> clazz, boolean singleton) {
        this.path = path;
        this.clazz = clazz;
        this.singleton = singleton;
    }

    public void resolve(WebEngine engine) throws ClassNotFoundException {
        if (this.clazz == null) {
            this.clazz = engine.loadClass(this.className);
            if (this.path == null) {
                this.hasUserPath = false;
                Path p = this.clazz.getAnnotation(Path.class);
                if (p == null) {
                    throw new NuxeoException("Invalid resource binding. Path not defined");
                }
                this.path = p.value();
            } else {
                this.hasUserPath = true;
            }
        }
    }

    public void reload(WebEngine engine) throws ClassNotFoundException {
        this.clazz = null;
        this.resolve(engine);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResourceBinding) {
            ResourceBinding binding = (ResourceBinding)obj;
            return binding.path.equals(this.path) && binding.clazz == this.clazz;
        }
        return false;
    }

    public static ResourceBinding fromAnnotation(Class<?> clazz) {
        Path path = clazz.getAnnotation(Path.class);
        ResourceBinding binding = null;
        if (path != null) {
            binding = new ResourceBinding();
            binding.path = path.value();
            binding.clazz = clazz;
        }
        return binding;
    }

    public String getPath() {
        return this.path;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public String toString() {
        return this.path + " -> " + this.clazz;
    }
}

