/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.externalblob;

import java.util.Collections;
import java.util.Map;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.externalblob.ExternalBlobAdapter;

public abstract class AbstractExternalBlobAdapter
implements ExternalBlobAdapter {
    protected String prefix;
    protected Map<String, String> properties;

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public String getProperty(String name) {
        Map<String, String> props = this.getProperties();
        String prop = props.get(name);
        prop = prop.trim();
        return prop;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getLocalName(String uri) throws PropertyException {
        String prefix = this.getPrefix();
        if (prefix == null) {
            throw new PropertyException(String.format("Null prefix on external blob adapter with class '%s'", this.getClass().getName()));
        }
        if (uri == null || !uri.startsWith(prefix + ":")) {
            throw new PropertyException(String.format("Invalid uri '%s' for this adapter: expected to start with prefix '%s'", uri, prefix));
        }
        return uri.substring(prefix.length() + 1);
    }
}

