/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.validation;

import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;

public class DocumentValidationException
extends NuxeoException {
    private static final String MESSAGE_SINGLE = "Constraint violation thrown: '%s'";
    private static final String MESSAGE = "%s constraint violation(s) thrown. First one is: '%s', call " + DocumentValidationException.class.getSimpleName() + ".getViolations() to get the others";
    private static final long serialVersionUID = 1L;
    private DocumentValidationReport report;

    public DocumentValidationException(DocumentValidationReport report) {
        this.report = report;
    }

    public DocumentValidationReport getReport() {
        return this.report;
    }

    @Override
    public String getMessage() {
        if (this.report.hasError()) {
            int num = this.report.numberOfErrors();
            String violationMessage = this.report.asList().get(0).getMessage(null);
            if (num > 1) {
                return String.format(MESSAGE, this.report.numberOfErrors(), violationMessage);
            }
            return String.format(MESSAGE_SINGLE, violationMessage);
        }
        return super.getMessage();
    }
}

