/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.nio.file.Path;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.PathStrategy;

public class PathStrategySubDirs
extends PathStrategy {
    protected static final Pattern PATTERN = Pattern.compile("[a-zA-Z0-9]+");
    protected final int depth;

    public PathStrategySubDirs(Path dir, int depth) {
        super(dir);
        this.depth = depth;
    }

    @Override
    public Path getPathForKey(String key) {
        if (!PATTERN.matcher(key).matches()) {
            throw new NuxeoException("Invalid key: " + key);
        }
        if (key.length() < 2 * this.depth) {
            return this.dir.resolve("000").resolve(key);
        }
        Path current = this.dir;
        for (int i = 0; i < this.depth; ++i) {
            current = current.resolve(key.substring(2 * i, 2 * i + 2));
        }
        return current.resolve(key);
    }
}

