/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerRootDescriptor;

public abstract class AbstractBinaryManager
implements BinaryManager {
    public static final String MD5_DIGEST = "MD5";
    @Deprecated
    public static final String SHA1_DIGEST = "SHA-1";
    @Deprecated
    public static final String SHA256_DIGEST = "SHA-256";
    @Deprecated
    public static final int MD5_DIGEST_LENGTH = 32;
    @Deprecated
    public static final int SHA1_DIGEST_LENGTH = 40;
    @Deprecated
    public static final int SHA256_DIGEST_LENGTH = 64;
    public static final Map<Integer, String> DIGESTS_BY_LENGTH;
    public static final String DEFAULT_DIGEST = "MD5";
    public static final int DEFAULT_DEPTH = 2;
    public String blobProviderId;
    protected Map<String, String> properties;
    protected BinaryManagerRootDescriptor descriptor;
    protected BinaryGarbageCollector garbageCollector;
    protected Pattern digestPattern;
    public static final int MIN_BUF_SIZE = 8192;
    public static final int MAX_BUF_SIZE = 65536;

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        this.blobProviderId = blobProviderId;
        this.properties = properties;
    }

    protected void setDescriptor(BinaryManagerRootDescriptor descriptor) {
        this.descriptor = descriptor;
        this.computeDigestPattern();
    }

    protected abstract Binary getBinary(InputStream var1) throws IOException;

    @Override
    public Binary getBinary(Blob blob) throws IOException {
        Binary binary;
        if (blob instanceof BinaryBlob && (binary = ((BinaryBlob)blob).getBinary()).getBlobProviderId().equals(this.blobProviderId)) {
            return binary;
        }
        try (InputStream stream = blob.getStream();){
            Binary binary2 = this.getBinary(stream);
            return binary2;
        }
    }

    @Override
    public abstract Binary getBinary(String var1);

    @Override
    public void removeBinaries(Collection<String> digests) {
        throw new UnsupportedOperationException();
    }

    protected BinaryManagerRootDescriptor getDescriptor(File configFile) throws IOException {
        BinaryManagerRootDescriptor desc;
        if (configFile.exists()) {
            XMap xmap = new XMap();
            xmap.register(BinaryManagerRootDescriptor.class);
            desc = (BinaryManagerRootDescriptor)xmap.load((InputStream)new FileInputStream(configFile));
        } else {
            desc = new BinaryManagerRootDescriptor();
            desc.digest = this.getDefaultDigestAlgorithm();
            desc.depth = 2;
            desc.write(configFile);
        }
        return desc;
    }

    protected String storeAndDigest(InputStream in, OutputStream out) throws IOException {
        int n;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(this.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw (IOException)new IOException().initCause(e);
        }
        int size = in.available();
        if (size == 0) {
            size = 65536;
        } else if (size < 8192) {
            size = 8192;
        } else if (size > 65536) {
            size = 65536;
        }
        byte[] buf = new byte[size];
        while ((n = in.read(buf)) != -1) {
            digest.update(buf, 0, n);
            out.write(buf, 0, n);
        }
        out.flush();
        return Hex.encodeHexString((byte[])digest.digest());
    }

    @Deprecated
    public static String toHexString(byte[] data) {
        return Hex.encodeHexString((byte[])data);
    }

    protected void computeDigestPattern() {
        int len = new DigestUtils(this.getDigestAlgorithm()).digestAsHex(new byte[0]).length();
        this.digestPattern = Pattern.compile("[0-9a-f]{" + len + "}");
    }

    public boolean isValidDigest(String digest) {
        return this.digestPattern.matcher(digest).matches();
    }

    @Override
    public BinaryGarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    @Override
    public String getDigestAlgorithm() {
        return this.descriptor.digest;
    }

    protected String getDefaultDigestAlgorithm() {
        return "MD5";
    }

    static {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(32, "MD5");
        map.put(40, SHA1_DIGEST);
        map.put(56, "SHA-224");
        map.put(64, SHA256_DIGEST);
        map.put(96, "SHA-384");
        map.put(128, "SHA-512");
        DIGESTS_BY_LENGTH = Collections.unmodifiableMap(map);
    }
}

