/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;

@Operation(id="Context.RestoreBlobsInput", category="Execution Context", label="Restore Files Input", description="Restore the file list input from a context variable given its name. Return the files.")
public class RestoreBlobsInput {
    public static final String ID = "Context.RestoreBlobsInput";
    @Context
    protected OperationContext ctx;
    @Param(name="name")
    protected String name;

    @OperationMethod
    public BlobList run() throws OperationException {
        Object obj = this.ctx.get(this.name);
        if (obj instanceof BlobList) {
            return (BlobList)obj;
        }
        if (obj instanceof Blob) {
            return new BlobList((Blob)obj);
        }
        throw new OperationException("Illegal state error for restore files operation. The context map doesn't contains a file list variable with name " + this.name);
    }
}

