/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.login;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Auth.LoginAs", category="Users & Groups", label="Login As", description="Login As the given user. If no user is given a system login is performed. This is a void operations - the input will be returned back as the output.")
public class LoginAs {
    public static final String ID = "Auth.LoginAs";
    @Context
    protected OperationContext ctx;
    @Param(name="name", required=false)
    protected String name;

    @OperationMethod
    public void run() throws LoginException, OperationException {
        NuxeoPrincipal origPrincipal;
        LoginContext lc = null;
        lc = this.name == null ? ((origPrincipal = this.ctx.getPrincipal()) != null ? Framework.loginAs((String)origPrincipal.getName()) : Framework.login()) : Framework.loginAsUser((String)this.name);
        if (lc != null) {
            this.ctx.getLoginStack().push(lc);
        }
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws LoginException, OperationException {
        this.run();
        return this.ctx.getCoreSession().getDocument(doc.getRef());
    }
}

