/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.trace.Call;
import org.nuxeo.ecm.automation.core.trace.Trace;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;

public class Tracer
implements OperationCallback {
    protected final TracerFactory factory;
    protected Stack<Context> stack = new Stack();

    protected Tracer(TracerFactory factory) {
        this.factory = factory;
    }

    protected void pushContext(OperationType chain) {
        this.stack.push(new Context(this.stack.isEmpty() ? null : this.stack.peek().calls.peekLast(), chain));
    }

    protected void popContext() {
        Context context = this.stack.pop();
        Trace trace = this.factory.newTrace(context.parent, context.typeof, context.calls, context.calls.getLast().getOutput(), context.error);
        if (this.stack.isEmpty()) {
            this.factory.onTrace(trace);
        } else {
            context.parent.nested.add(trace);
        }
    }

    @Override
    public void onChainEnter(OperationType chain) {
        this.pushContext(chain);
    }

    @Override
    public void onChainExit() {
        this.popContext();
    }

    @Override
    public void onOperationEnter(OperationContext context, OperationType type, InvokableMethod method, Map<String, Object> params) {
        this.stack.peek().calls.add(this.factory.newCall(this.stack.peek().typeof, context, type, method, params));
    }

    @Override
    public void onOperationExit(Object output) {
        this.stack.peek().calls.peekLast().details.output = output;
    }

    @Override
    public OperationException onError(OperationException error) {
        this.stack.peek().error = error;
        return this.stack.peek().error;
    }

    class Context {
        final Call parent;
        final OperationType typeof;
        final LinkedList<Call> calls = new LinkedList();
        OperationException error;

        Context(Call parent, OperationType oftype) {
            this.parent = parent;
            this.typeof = oftype;
        }
    }
}

