/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.platform.usermanager.GroupConfig;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.runtime.api.login.Authenticator;
import org.nuxeo.runtime.services.event.EventListener;

public interface UserManager
extends Authenticator,
EventListener,
Serializable {
    public boolean checkUsernamePassword(String var1, String var2);

    public boolean validatePassword(String var1);

    public NuxeoPrincipal getPrincipal(String var1);

    default public NuxeoPrincipal getPrincipal(String username, boolean fetchReferences) {
        return this.getPrincipal(username);
    }

    public NuxeoGroup getGroup(String var1);

    @Deprecated
    public List<NuxeoPrincipal> searchPrincipals(String var1);

    public DocumentModelList searchGroups(String var1);

    public List<String> getUserIds();

    public DocumentModel createUser(DocumentModel var1) throws UserAlreadyExistsException;

    public void updateUser(DocumentModel var1);

    public void deleteUser(DocumentModel var1);

    public void deleteUser(String var1);

    public DocumentModel getBareUserModel();

    public DocumentModel getUserModel(String var1);

    public DocumentModelList searchUsers(String var1);

    public DocumentModelList searchUsers(Map<String, Serializable> var1, Set<String> var2);

    public DocumentModelList searchUsers(QueryBuilder var1);

    public String getUserListingMode();

    public String getUserSortField();

    public Pattern getUserPasswordPattern();

    public List<String> getGroupIds();

    public DocumentModelList searchGroups(Map<String, Serializable> var1, Set<String> var2);

    public DocumentModelList searchGroups(QueryBuilder var1);

    public DocumentModel createGroup(DocumentModel var1) throws GroupAlreadyExistsException;

    public void updateGroup(DocumentModel var1);

    public void deleteGroup(DocumentModel var1);

    public void deleteGroup(String var1);

    public DocumentModel getBareGroupModel();

    public DocumentModel getGroupModel(String var1);

    public String getDefaultGroup();

    public String getGroupListingMode();

    public List<String> getGroupsInGroup(String var1);

    public List<String> getTopLevelGroups();

    public List<String> getUsersInGroup(String var1);

    public List<String> getUsersInGroupAndSubGroups(String var1);

    public Boolean areGroupsReadOnly();

    public Boolean areUsersReadOnly();

    public String getUserDirectoryName();

    public String getUserSchemaName();

    public String getUserIdField();

    public String getUserEmailField();

    public Set<String> getUserSearchFields();

    public Set<String> getGroupSearchFields();

    public String getGroupDirectoryName();

    public String getGroupSchemaName();

    public String getGroupIdField();

    public String getGroupLabelField();

    public String getGroupMembersField();

    public String getGroupSubGroupsField();

    public String getGroupParentGroupsField();

    public String getAnonymousUserId();

    public String getDigestAuthDirectory();

    public String getDigestAuthRealm();

    public void setConfiguration(UserManagerDescriptor var1);

    public List<String> getAdministratorsGroups();

    public String[] getUsersForPermission(String var1, ACP var2);

    public List<String> getAncestorGroups(String var1);

    public GroupConfig getGroupConfig();

    public void notifyUserChanged(String var1, String var2);

    default public void notifyGroupChanged(String groupName, String eventId) {
        this.notifyGroupChanged(groupName, eventId, null);
    }

    public void notifyGroupChanged(String var1, String var2, List<String> var3);

    public static enum MatchType {
        EXACT,
        SUBSTRING;

    }
}

