/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.codec;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.message.BadHeaderException;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.reflect.ReflectData;
import org.nuxeo.lib.stream.codec.AvroSchemaStore;
import org.nuxeo.lib.stream.codec.Codec;

public class AvroMessageCodec<T>
implements Codec<T> {
    public static final String NAME = "avro";
    protected final Class<T> messageClass;
    protected final Schema schema;
    protected final BinaryMessageEncoder<T> encoder;
    protected final BinaryMessageDecoder<T> decoder;

    public AvroMessageCodec(Class<T> messageClass, AvroSchemaStore store) {
        this.messageClass = messageClass;
        this.schema = ReflectData.get().getSchema(messageClass);
        if (store != null) {
            store.addSchema(this.schema);
        }
        this.encoder = new BinaryMessageEncoder((GenericData)ReflectData.get(), this.schema);
        this.decoder = new BinaryMessageDecoder((GenericData)ReflectData.get(), this.schema, (SchemaStore)store);
    }

    public AvroMessageCodec(Class<T> messageClass) {
        this(messageClass, null);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] encode(T object) {
        try {
            return this.encoder.encode(object).array();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T decode(byte[] data) {
        try {
            return (T)this.decoder.decode(data, null);
        }
        catch (IOException | BadHeaderException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

