/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.FacetDescriptor;
import org.nuxeo.ecm.core.schema.PropertyCharacteristicHandler;
import org.nuxeo.ecm.core.schema.PropertyDeprecationDescriptor;
import org.nuxeo.ecm.core.schema.PropertyDescriptor;
import org.nuxeo.ecm.core.schema.ProxiesDescriptor;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.ecm.core.schema.TypeConfiguration;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class TypeService
extends DefaultComponent {
    private static final String XP_SCHEMA = "schema";
    private static final String XP_DOCTYPE = "doctype";
    private static final String XP_CONFIGURATION = "configuration";
    private static final String XP_DEPRECATION = "deprecation";
    private SchemaManagerImpl schemaManager;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.schemaManager = new SchemaManagerImpl();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.schemaManager = null;
    }

    public void registerExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        Object[] contribs = extension.getContributions();
        switch (xp) {
            case "doctype": {
                for (Object contrib : contribs) {
                    if (contrib instanceof DocumentTypeDescriptor) {
                        this.schemaManager.registerDocumentType((DocumentTypeDescriptor)contrib);
                        continue;
                    }
                    if (contrib instanceof FacetDescriptor) {
                        this.schemaManager.registerFacet((FacetDescriptor)contrib);
                        continue;
                    }
                    if (!(contrib instanceof ProxiesDescriptor)) continue;
                    this.schemaManager.registerProxies((ProxiesDescriptor)contrib);
                }
                break;
            }
            case "schema": {
                for (Object contrib : contribs) {
                    if (contrib instanceof SchemaBindingDescriptor) {
                        SchemaBindingDescriptor sbd = (SchemaBindingDescriptor)contrib;
                        sbd.context = extension.getContext();
                        this.schemaManager.registerSchema(sbd);
                        continue;
                    }
                    if (!(contrib instanceof PropertyDescriptor)) continue;
                    xp = this.computeSchemaExtensionPoint(contrib.getClass());
                    super.registerContribution(contrib, xp, extension.getComponent());
                }
                break;
            }
            case "configuration": {
                for (Object contrib : contribs) {
                    this.schemaManager.registerConfiguration((TypeConfiguration)contrib);
                }
                break;
            }
            case "deprecation": {
                for (Object contrib : contribs) {
                    this.schemaManager.registerPropertyDeprecation((PropertyDeprecationDescriptor)contrib);
                }
                break;
            }
        }
    }

    public void unregisterExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        Object[] contribs = extension.getContributions();
        switch (xp) {
            case "doctype": {
                for (Object contrib : contribs) {
                    if (contrib instanceof DocumentTypeDescriptor) {
                        this.schemaManager.unregisterDocumentType((DocumentTypeDescriptor)contrib);
                        continue;
                    }
                    if (contrib instanceof FacetDescriptor) {
                        this.schemaManager.unregisterFacet((FacetDescriptor)contrib);
                        continue;
                    }
                    if (!(contrib instanceof ProxiesDescriptor)) continue;
                    this.schemaManager.unregisterProxies((ProxiesDescriptor)contrib);
                }
                break;
            }
            case "schema": {
                for (Object contrib : contribs) {
                    if (contrib instanceof SchemaBindingDescriptor) {
                        this.schemaManager.unregisterSchema((SchemaBindingDescriptor)contrib);
                        continue;
                    }
                    if (!(contrib instanceof PropertyDescriptor)) continue;
                    xp = this.computeSchemaExtensionPoint(contrib.getClass());
                    super.unregisterContribution(contrib, xp, extension.getComponent());
                }
                break;
            }
            case "configuration": {
                for (Object contrib : contribs) {
                    this.schemaManager.unregisterConfiguration((TypeConfiguration)contrib);
                }
                break;
            }
            case "deprecation": {
                for (Object contrib : contribs) {
                    this.schemaManager.unregisterPropertyDeprecation((PropertyDeprecationDescriptor)contrib);
                }
                break;
            }
        }
    }

    protected String computeSchemaExtensionPoint(Class<?> klass) {
        return String.format("%s-%s", XP_SCHEMA, klass.getSimpleName());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (SchemaManager.class.isAssignableFrom(adapter) || PropertyCharacteristicHandler.class.isAssignableFrom(adapter) || TypeProvider.class.isAssignableFrom(adapter)) {
            return (T)this.schemaManager;
        }
        return null;
    }

    public void start(ComponentContext context) {
        this.schemaManager.registerSecuredProperty(this.getDescriptors(this.computeSchemaExtensionPoint(PropertyDescriptor.class)));
        this.schemaManager.flushPendingsRegistration();
    }

    public void stop(ComponentContext context) {
        this.schemaManager.clearSecuredProperty();
    }

    public int getApplicationStartedOrder() {
        return -100;
    }
}

