/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ProbeStatus {
    protected boolean neverExecuted = false;
    protected final boolean success;
    protected final Map<String, String> infos = new HashMap<String, String>();
    public static final String DEFAULT_INFO_FIELD = "info";
    public static final String ERROR_FIELD = "error";

    protected ProbeStatus(String info, Boolean success) {
        this.infos.put(DEFAULT_INFO_FIELD, info);
        this.success = success;
    }

    protected ProbeStatus(Map<String, String> infos, Boolean success) {
        this.infos.putAll(infos);
        this.success = success;
    }

    public static ProbeStatus newBlankProbStatus() {
        ProbeStatus status = new ProbeStatus("[unavailable]", (Boolean)false);
        status.neverExecuted = true;
        return status;
    }

    public static ProbeStatus newFailure(String info) {
        return new ProbeStatus(info, Boolean.FALSE);
    }

    public static ProbeStatus newFailure(Map<String, String> infos) {
        return new ProbeStatus(infos, Boolean.FALSE);
    }

    public static ProbeStatus newError(Throwable t) {
        HashMap<String, String> infos = new HashMap<String, String>();
        infos.put(ERROR_FIELD, t.toString());
        infos.put(DEFAULT_INFO_FIELD, "Caught error " + t.toString());
        return new ProbeStatus(infos, Boolean.FALSE);
    }

    public static ProbeStatus newSuccess(String info) {
        return new ProbeStatus(info, Boolean.TRUE);
    }

    public static ProbeStatus newSuccess(Map<String, String> infos) {
        return new ProbeStatus(infos, Boolean.TRUE);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.success;
    }

    public boolean isNeverExecuted() {
        return this.neverExecuted;
    }

    public String getAsString() {
        if (this.infos == null || this.infos.isEmpty()) {
            return Boolean.toString(this.success);
        }
        if (this.infos.size() == 1) {
            return this.infos.values().iterator().next();
        }
        StringBuilder sb = new StringBuilder();
        for (String key : this.infos.keySet()) {
            sb.append(key);
            sb.append(" : ");
            sb.append(this.infos.get(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getAsString();
    }

    public String getAsXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<dl>");
        for (String key : this.infos.keySet()) {
            sb.append("<dt>");
            sb.append(key);
            sb.append("</dt>");
            sb.append("<dd class='").append(key).append("'>");
            sb.append(this.infos.get(key));
            sb.append("</dd>");
        }
        sb.append("</dl>");
        return sb.toString();
    }

    public Map<String, String> getInfos() {
        return Collections.unmodifiableMap(this.infos);
    }
}

