/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.application.loader.FrameworkLoader;
import org.osgi.framework.BundleException;

public class NuxeoStarter
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(NuxeoStarter.class);
    private static final String DEFAULT_HOME = "nuxeo";
    public static final String NUXEO_BUNDLES_LIST = ".nuxeo-bundles";
    protected final Map<String, Object> env = new HashMap<String, Object>();
    protected List<File> bundleFiles = new ArrayList<File>();

    public void contextInitialized(ServletContextEvent event) {
        try {
            long startTime = System.currentTimeMillis();
            this.start(event);
            long finishedTime = System.currentTimeMillis();
            Double duration = (double)(finishedTime - startTime) / 1000.0;
            log.info((Object)String.format("Nuxeo framework started in %.1f sec.", duration));
        }
        catch (IOException | BundleException e) {
            log.error((Object)"Exception during startup", e);
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            log.error((Object)"Exception during startup", e);
            throw e;
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            this.stop();
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    protected void start(ServletContextEvent event) throws IOException, BundleException {
        ServletContext servletContext = event.getServletContext();
        this.findBundles(servletContext);
        this.findEnv(servletContext);
        ClassLoader cl = this.getClass().getClassLoader();
        File home = new File((String)this.env.get("nuxeo.runtime.home"));
        FrameworkLoader.initialize((ClassLoader)cl, (File)home, this.bundleFiles, this.env);
        FrameworkLoader.start();
    }

    protected void stop() throws BundleException {
        FrameworkLoader.stop();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                log.info((Object)String.format("Deregister JDBC driver: %s", driver));
            }
            catch (SQLException e) {
                log.error((Object)String.format("Error deregistering JDBC driver %s", driver), (Throwable)e);
            }
        }
    }

    protected void findBundles(ServletContext servletContext) throws IOException {
        InputStream bundlesListStream = servletContext.getResourceAsStream("/WEB-INF/.nuxeo-bundles");
        if (bundlesListStream != null) {
            File lib = new File(servletContext.getRealPath("/WEB-INF/lib/"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(bundlesListStream));
            Object object = null;
            try {
                String bundleName;
                while ((bundleName = reader.readLine()) != null) {
                    this.bundleFiles.add(new File(lib, bundleName));
                }
            }
            catch (Throwable bundleName) {
                object = bundleName;
                throw bundleName;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable bundleName) {
                            ((Throwable)object).addSuppressed(bundleName);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        if (this.bundleFiles.isEmpty()) {
            File root = new File(servletContext.getRealPath("/"));
            Set ctxpaths = servletContext.getResourcePaths("/WEB-INF/lib/");
            if (ctxpaths != null) {
                for (String ctxpath : ctxpaths) {
                    if (!ctxpath.endsWith(".jar")) continue;
                    this.bundleFiles.add(new File(root, ctxpath));
                }
            }
        }
    }

    protected void findEnv(ServletContext servletContext) {
        for (String param : Arrays.asList("nuxeo.runtime.home", "nuxeo.config.dir", "nuxeo.data.dir", "nuxeo.log.dir", "nuxeo.tmp.dir", "nuxeo.web.dir")) {
            String value = servletContext.getInitParameter(param);
            if (value == null || "".equals(value.trim())) continue;
            this.env.put(param, value);
        }
        if (!this.env.containsKey("nuxeo.config.dir")) {
            String webinf = servletContext.getRealPath("/WEB-INF");
            this.env.put("nuxeo.config.dir", webinf);
        }
        if (!this.env.containsKey("nuxeo.runtime.home")) {
            File home = new File(DEFAULT_HOME);
            this.env.put("nuxeo.runtime.home", home.getAbsolutePath());
        }
        if (this.getClass().getClassLoader().getClass().getName().startsWith("org.jboss.classloader")) {
            this.env.put("org.nuxeo.app.host.name", "JBoss");
        } else if (servletContext.getClass().getName().startsWith("org.apache.catalina")) {
            this.env.put("org.nuxeo.app.host.name", "Tomcat");
        }
    }
}

