/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoException;

public class BulkParameters {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private BulkParameters() {
    }

    public static Map<String, Serializable> paramsToMap(String jsonParams) throws IOException {
        if (StringUtils.isBlank((CharSequence)jsonParams)) {
            return Collections.emptyMap();
        }
        return BulkParameters.paramsToMap(OBJECT_MAPPER.readTree(jsonParams));
    }

    public static HashMap<String, Serializable> paramsToMap(JsonNode node) {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        if (node == null) {
            return params;
        }
        Iterable paramNodes = () -> ((JsonNode)node).fields();
        for (Map.Entry paramNode : paramNodes) {
            params.put((String)paramNode.getKey(), BulkParameters.toSerializable((JsonNode)paramNode.getValue()));
        }
        return params;
    }

    protected static ArrayList<Serializable> toList(JsonNode value) {
        return StreamSupport.stream(value.spliterator(), false).map(BulkParameters::toSerializable).collect(Collectors.toCollection(ArrayList::new));
    }

    protected static Serializable toSerializable(JsonNode value) {
        Serializable serializableValue;
        switch (value.getNodeType()) {
            case STRING: 
            case BINARY: {
                serializableValue = value.asText();
                break;
            }
            case BOOLEAN: {
                serializableValue = value.asBoolean();
                break;
            }
            case NUMBER: {
                serializableValue = value.asLong();
                break;
            }
            case ARRAY: {
                serializableValue = BulkParameters.toList(value);
                break;
            }
            case OBJECT: {
                serializableValue = BulkParameters.paramsToMap(value);
                break;
            }
            default: {
                throw new NuxeoException("Node type=" + value.getNodeType() + " is not supported");
            }
        }
        return serializableValue;
    }
}

