/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.core.bulk.message.MapAsJsonAsStringEncoding;

public class BulkCommand
implements Serializable {
    private static final long serialVersionUID = 20181021L;
    protected String id;
    protected String action;
    protected String query;
    @Nullable
    protected String username;
    @Nullable
    protected String repository;
    protected int bucketSize;
    protected int batchSize;
    @Nullable
    protected String scroller;
    @AvroEncode(using=MapAsJsonAsStringEncoding.class)
    protected Map<String, Serializable> params;

    protected BulkCommand() {
    }

    public BulkCommand(Builder builder) {
        this.id = UUID.randomUUID().toString();
        this.username = builder.username;
        this.repository = builder.repository;
        this.query = builder.query;
        this.action = builder.action;
        this.bucketSize = builder.bucketSize;
        this.batchSize = builder.batchSize;
        this.params = builder.params;
        this.scroller = builder.scroller;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getQuery() {
        return this.query;
    }

    public String getAction() {
        return this.action;
    }

    public String getScroller() {
        return this.scroller;
    }

    public Map<String, Serializable> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public <T> T getParam(String key) {
        return (T)this.params.get(key);
    }

    public String getId() {
        return this.id;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setScroller(String scrollerName) {
        this.scroller = scrollerName;
    }

    public static class Builder {
        protected final String action;
        protected final String query;
        protected String repository;
        protected String username;
        protected int bucketSize;
        protected int batchSize;
        protected String scroller;
        protected Map<String, Serializable> params = new HashMap<String, Serializable>();

        public Builder(String action, String nxqlQuery) {
            if (StringUtils.isEmpty((CharSequence)action)) {
                throw new IllegalArgumentException("Action cannot be empty");
            }
            this.action = action;
            if (StringUtils.isEmpty((CharSequence)nxqlQuery)) {
                throw new IllegalArgumentException("Query cannot be empty");
            }
            this.query = nxqlQuery;
        }

        public Builder repository(String name) {
            this.repository = name;
            return this;
        }

        public Builder user(String name) {
            this.username = name;
            return this;
        }

        public Builder bucket(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Invalid bucket size must > 0");
            }
            if (this.batchSize > size) {
                throw new IllegalArgumentException(String.format("Bucket size: %d must be greater or equals to batch size: %d", size, this.batchSize));
            }
            this.bucketSize = size;
            return this;
        }

        public Builder batch(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Invalid batch size must > 0");
            }
            if (this.bucketSize > 0 && size > this.bucketSize) {
                throw new IllegalArgumentException(String.format("Bucket size: %d must be greater or equals to batch size: %d", size, this.batchSize));
            }
            this.batchSize = size;
            return this;
        }

        public Builder param(String key, Serializable value) {
            if (StringUtils.isEmpty((CharSequence)key)) {
                throw new IllegalArgumentException("Param key cannot be null");
            }
            this.params.put(key, value);
            return this;
        }

        public Builder params(Map<String, Serializable> params) {
            if (params != null && !params.isEmpty()) {
                if (params.containsKey(null)) {
                    throw new IllegalArgumentException("Param key cannot be null");
                }
                this.params = params;
            }
            return this;
        }

        public Builder scroller(String scrollerName) {
            this.scroller = scrollerName;
            return this;
        }

        public BulkCommand build() {
            return new BulkCommand(this);
        }
    }
}

