/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.validation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.bulk.AbstractBulkActionValidation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;

public class SetPropertiesValidation
extends AbstractBulkActionValidation {
    @Override
    public void validate(BulkCommand command) throws IllegalArgumentException {
        HashSet<String> params = new HashSet<String>(command.getParams().keySet());
        params.removeAll(this.getParametersToValidate());
        for (String param : params) {
            this.validateXpath(null, (Serializable)((Object)param), command);
        }
        this.validateCommand(command);
    }

    @Override
    protected List<String> getParametersToValidate() {
        return Arrays.asList("disableAuditLogger", "VersioningOption");
    }

    @Override
    protected void validateCommand(BulkCommand command) throws IllegalArgumentException {
        this.validateBoolean("disableAuditLogger", command);
        this.validateString("VersioningOption", command);
        String versioningOption = (String)command.getParam("VersioningOption");
        if (versioningOption != null && Stream.of(VersioningOption.values()).noneMatch(op -> versioningOption.equals(op.name()))) {
            throw new IllegalArgumentException(this.invalidParameterMessage("VersioningOption", command));
        }
    }
}

