/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scroll;

import java.time.Duration;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.api.scroll.ScrollRequest;
import org.nuxeo.runtime.api.Framework;

public class DocumentScrollRequest
implements ScrollRequest {
    protected static final String SCROLL_TYPE = "document";
    protected final String name;
    protected final String query;
    protected final String repository;
    protected final Duration timeout;
    protected final int size;
    protected final String username;

    protected DocumentScrollRequest(Builder builder) {
        this.name = builder.getName();
        this.query = builder.getQuery();
        this.timeout = builder.getTimeout();
        this.size = builder.getSize();
        this.username = builder.getUsername();
        this.repository = builder.getRepository();
    }

    public String getType() {
        return SCROLL_TYPE;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public String getQuery() {
        return this.query;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRepository() {
        return this.repository;
    }

    public String toString() {
        return "DocumentScrollRequest{name='" + this.name + '\'' + ", query='" + this.query + '\'' + ", repository='" + this.repository + '\'' + ", timeout=" + this.timeout + ", size=" + this.size + ", username='" + this.username + '\'' + '}';
    }

    public static Builder builder(String nxqlQuery) {
        return new Builder(nxqlQuery);
    }

    public static class Builder {
        protected final String query;
        protected String name;
        protected String username;
        protected String repository;
        protected Duration timeout;
        protected int size;
        public static final String UNKNOWN = "unknown";
        public static final int DEFAULT_SCROLL_SIZE = 50;
        public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(120L);

        protected Builder(String nxqlQuery) {
            this.query = Objects.requireNonNull(nxqlQuery, "NXQL query cannot be null");
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = Objects.requireNonNull(timeout, "Timeout cannot be null");
            return this;
        }

        public Builder size(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("size must be > 0");
            }
            this.size = size;
            return this;
        }

        public Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public Duration getTimeout() {
            return this.timeout == null ? DEFAULT_TIMEOUT : this.timeout;
        }

        public int getSize() {
            return this.size == 0 ? 50 : this.size;
        }

        public String getUsername() {
            return this.username == null ? UNKNOWN : this.username;
        }

        public String getRepository() {
            if (StringUtils.isEmpty((CharSequence)this.repository)) {
                RepositoryManager repoManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
                if (repoManager == null) {
                    return UNKNOWN;
                }
                return repoManager.getDefaultRepositoryName();
            }
            return this.repository;
        }

        public DocumentScrollRequest build() {
            return new DocumentScrollRequest(this);
        }
    }
}

