/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.DefaultBlobDispatcher;
import org.nuxeo.ecm.core.model.Document;

public class MultiTenantBlobDispatcher
extends DefaultBlobDispatcher {
    private static final Log log = LogFactory.getLog(MultiTenantBlobDispatcher.class);
    protected static final String TENANT_NAME = "ecm:tenant";
    protected static final String TENANT_FACET = "TenantConfig";
    protected static final String TENANT_XPATH = "tenantconfig:tenantId";

    protected Object getValue(Document doc, Blob blob, String blobXPath, DefaultBlobDispatcher.Clause clause) {
        String xpath = clause.xpath;
        if (xpath.equals(TENANT_NAME)) {
            return this.findTenant(doc, clause);
        }
        return super.getValue(doc, blob, blobXPath, clause);
    }

    protected Object getTenant(Document doc) {
        if (doc != null && doc.hasFacet(TENANT_FACET)) {
            return doc.getValue(TENANT_XPATH);
        }
        return null;
    }

    protected Object findTenant(Document doc, DefaultBlobDispatcher.Clause clause) {
        Object tenant = this.getTenant(doc);
        while (tenant == null && doc != null) {
            doc = doc.getParent();
            tenant = this.getTenant(doc);
        }
        if (tenant == null && doc == null) {
            log.warn((Object)("Tenant configuration not found in parent path for dispatch rule: " + clause.xpath + clause.op + clause.value));
            log.warn((Object)"Is multi-tenant properly configured?");
        }
        return tenant;
    }
}

