/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql;

import java.time.format.DateTimeParseException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.chrono.ISOChronology;
import org.nuxeo.common.utils.PeriodAndDuration;
import org.nuxeo.runtime.api.Framework;

public class NXQL {
    public static final String TEST_NXQL_NOW = "test.nxql.now";
    public static final String NXQL = "NXQL";
    public static final String ECM_PREFIX = "ecm:";
    public static final String ECM_UUID = "ecm:uuid";
    public static final String ECM_PATH = "ecm:path";
    public static final String ECM_NAME = "ecm:name";
    public static final String ECM_POS = "ecm:pos";
    public static final String ECM_PARENTID = "ecm:parentId";
    public static final String ECM_MIXINTYPE = "ecm:mixinType";
    public static final String ECM_PRIMARYTYPE = "ecm:primaryType";
    public static final String ECM_ISPROXY = "ecm:isProxy";
    public static final String ECM_ISVERSION = "ecm:isVersion";
    public static final String ECM_ISVERSION_OLD = "ecm:isCheckedInVersion";
    public static final String ECM_LIFECYCLESTATE = "ecm:currentLifeCycleState";
    public static final String ECM_VERSIONLABEL = "ecm:versionLabel";
    public static final String ECM_FULLTEXT = "ecm:fulltext";
    public static final String ECM_FULLTEXT_JOBID = "ecm:fulltextJobId";
    public static final String ECM_FULLTEXT_SCORE = "ecm:fulltextScore";
    public static final String ECM_LOCK_OWNER = "ecm:lockOwner";
    public static final String ECM_LOCK_CREATED = "ecm:lockCreated";
    public static final String ECM_TAG = "ecm:tag";
    public static final String ECM_PROXY_TARGETID = "ecm:proxyTargetId";
    public static final String ECM_PROXY_VERSIONABLEID = "ecm:proxyVersionableId";
    public static final String ECM_ISCHECKEDIN = "ecm:isCheckedIn";
    public static final String ECM_ISLATESTVERSION = "ecm:isLatestVersion";
    public static final String ECM_ISLATESTMAJORVERSION = "ecm:isLatestMajorVersion";
    public static final String ECM_VERSIONCREATED = "ecm:versionCreated";
    public static final String ECM_VERSIONDESCRIPTION = "ecm:versionDescription";
    public static final String ECM_VERSION_VERSIONABLEID = "ecm:versionVersionableId";
    public static final String ECM_ANCESTORID = "ecm:ancestorId";
    public static final String ECM_ACL = "ecm:acl";
    public static final String ECM_ACL_PRINCIPAL = "principal";
    public static final String ECM_ACL_PERMISSION = "permission";
    public static final String ECM_ACL_GRANT = "grant";
    public static final String ECM_ACL_NAME = "name";
    public static final String ECM_ACL_POS = "pos";
    public static final String ECM_ACL_CREATOR = "creator";
    public static final String ECM_ACL_BEGIN = "begin";
    public static final String ECM_ACL_END = "end";
    public static final String ECM_ACL_STATUS = "status";
    public static final String ECM_ISTRASHED = "ecm:isTrashed";
    public static final String ECM_ISRECORD = "ecm:isRecord";
    public static final String ECM_RETAINUNTIL = "ecm:retainUntil";
    public static final String ECM_HASLEGALHOLD = "ecm:hasLegalHold";
    public static final String NOW_FUNCTION = "NOW";

    private NXQL() {
    }

    public static String escapeString(String s) {
        return "'" + org.nuxeo.ecm.core.query.sql.NXQL.escapeStringInner(s) + "'";
    }

    public static String escapeStringInner(String s) {
        return s.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'").replaceAll("\n", "\\\\n");
    }

    public static DateTime nowPlusPeriodAndDuration(String periodAndDurationText) {
        DateTime now = Framework.getProperty((String)TEST_NXQL_NOW) != null ? DateTime.parse((String)Framework.getProperty((String)TEST_NXQL_NOW)) : new DateTime((Chronology)ISOChronology.getInstanceUTC());
        if (periodAndDurationText == null) {
            return now;
        }
        return org.nuxeo.ecm.core.query.sql.NXQL.addPeriondAndDuration(now, periodAndDurationText);
    }

    public static DateTime addPeriondAndDuration(DateTime dateTime, String text) {
        PeriodAndDuration pd;
        try {
            pd = PeriodAndDuration.parse((String)text);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid period: " + text, e);
        }
        return dateTime.plusYears(pd.period.getYears()).plusMonths(pd.period.getMonths()).plusDays(pd.period.getDays()).plus((ReadableDuration)Duration.millis((long)pd.duration.toMillis()));
    }
}

